/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.Iterator;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalActivationGroup;
import org.drools.core.rule.consequence.InternalMatch;
import org.drools.core.util.LinkedList;

public class ActivationGroupImpl
implements InternalActivationGroup {
    private final String name;
    private final LinkedList<ActivationGroupNode> list;
    private final ActivationsManager activationsManager;
    private long triggeredForRecency;

    public ActivationGroupImpl(ActivationsManager activationsManager, String name) {
        this.activationsManager = activationsManager;
        this.name = name;
        this.list = new LinkedList();
        this.triggeredForRecency = -1L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addActivation(InternalMatch internalMatch) {
        ActivationGroupNode node = new ActivationGroupNode(internalMatch, this);
        internalMatch.setActivationGroupNode(node);
        this.list.add(node);
    }

    @Override
    public void removeActivation(InternalMatch internalMatch) {
        ActivationGroupNode node = internalMatch.getActivationGroupNode();
        this.list.remove(node);
        internalMatch.setActivationGroupNode(null);
    }

    @Override
    public Iterator iterator() {
        return this.list.javaUtilIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.activationsManager.clearAndCancelActivationGroup(this.name);
    }

    @Override
    public void reset() {
        this.list.clear();
    }

    @Override
    public LinkedList<ActivationGroupNode> getList() {
        return this.list;
    }

    @Override
    public long getTriggeredForRecency() {
        return this.triggeredForRecency;
    }

    @Override
    public void setTriggeredForRecency(long executedForRecency) {
        this.triggeredForRecency = executedForRecency;
    }

    public String toString() {
        return "activation-group: " + this.name;
    }
}

