/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.core.common.FactHandleClassStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.Storage;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.ObjectFilter;

public abstract class MapObjectStore
implements Externalizable,
ObjectStore {
    private Storage<Object, InternalFactHandle> fhStorage;

    protected MapObjectStore(Map<Object, InternalFactHandle> fhMap) {
        this.fhStorage = Storage.fromMap(fhMap);
    }

    protected MapObjectStore(Storage<Object, InternalFactHandle> fhStorage) {
        this.fhStorage = fhStorage;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fhStorage);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fhStorage = (Storage)in.readObject();
    }

    @Override
    public int size() {
        return this.fhStorage.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fhStorage.isEmpty();
    }

    @Override
    public void clear() {
        this.fhStorage.clear();
    }

    @Override
    public Object getObjectForHandle(InternalFactHandle handle) {
        InternalFactHandle reconnectedHandle = this.reconnect(handle);
        return reconnectedHandle != null ? reconnectedHandle.getObject() : null;
    }

    @Override
    public InternalFactHandle reconnect(InternalFactHandle handle) {
        InternalFactHandle reconnectedHandle = this.fhStorage.values().stream().filter(fh -> fh.getId() == handle.getId()).findFirst().orElse(null);
        return reconnectedHandle != null && handle.getIdentityHashCode() == reconnectedHandle.getIdentityHashCode() ? reconnectedHandle : null;
    }

    @Override
    public InternalFactHandle getHandleForObject(Object object) {
        return this.fhStorage.get(object);
    }

    @Override
    public void updateHandle(InternalFactHandle handle, Object object) {
        this.removeHandle(handle);
        handle.setObject(object);
        this.addHandle(handle, object);
    }

    @Override
    public void addHandle(InternalFactHandle handle, Object object) {
        this.fhStorage.put(object, handle);
    }

    @Override
    public void removeHandle(InternalFactHandle handle) {
        this.fhStorage.remove(handle.getObject());
    }

    @Override
    public Iterator<Object> iterateObjects() {
        return this.fhStorage.keySet().iterator();
    }

    @Override
    public Iterator<Object> iterateObjects(ObjectFilter filter) {
        return this.fhStorage.keySet().stream().filter(filter::accept).iterator();
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles() {
        return this.fhStorage.values().iterator();
    }

    @Override
    public Iterator<InternalFactHandle> iterateFactHandles(ObjectFilter filter) {
        return this.fhStorage.values().stream().filter(fh -> filter.accept(fh.getObject())).iterator();
    }

    @Override
    public Iterator<Object> iterateNegObjects(ObjectFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<InternalFactHandle> iterateNegFactHandles(ObjectFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FactHandleClassStore getStoreForClass(Class<?> clazz) {
        return new MapFactHandleClassStore(clazz);
    }

    @Override
    public boolean clearClassStore(Class<?> clazz) {
        ClassObjectFilter filter = new ClassObjectFilter(clazz);
        List<Object> toBeRemoved = this.fhStorage.keySet().stream().filter(filter::accept).collect(Collectors.toList());
        toBeRemoved.forEach(this.fhStorage::remove);
        return !toBeRemoved.isEmpty();
    }

    public class MapFactHandleClassStore
    implements FactHandleClassStore {
        private final Class<?> clazz;

        public MapFactHandleClassStore(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Iterator<InternalFactHandle> iterator() {
            ClassObjectFilter filter = new ClassObjectFilter(this.clazz);
            return MapObjectStore.this.fhStorage.values().stream().filter(fh -> filter.accept(fh.getObject())).collect(Collectors.toList()).iterator();
        }
    }
}

