/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.base.ObjectType;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.reteoo.NodeTypeEnums;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.IntervalProviderConstraint;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.base.rule.constraint.BetaNodeFieldConstraint;
import org.drools.base.time.Interval;
import org.drools.base.time.TimeUtils;
import org.drools.core.common.BaseNode;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BetaNodeConstraintFactory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.time.TemporalDependencyMatrix;
import org.kie.api.definition.rule.Rule;

public class BuildUtils {
    private final Map<Class<?>, ReteooComponentBuilder> componentBuilders = new HashMap();

    public void addBuilder(Class<?> target, ReteooComponentBuilder builder) {
        this.componentBuilders.put(target, builder);
    }

    public ReteooComponentBuilder getBuilderFor(RuleConditionElement target) {
        return this.getBuilderFor(target.getClass());
    }

    public ReteooComponentBuilder getBuilderFor(Class cls) {
        ReteooComponentBuilder builder = this.componentBuilders.get(cls);
        return builder != null || cls.getSuperclass() == null ? builder : this.getBuilderFor(cls.getSuperclass());
    }

    public <T extends BaseNode> T attachNode(BuildContext context, T candidate) {
        BaseNode node = null;
        RuleBasePartitionId partition = null;
        if (candidate.getType() == 10) {
            node = context.getRuleBase().getRete().getEntryPointNode(((EntryPointNode)candidate).getEntryPoint());
            partition = RuleBasePartitionId.MAIN_PARTITION;
        } else if (candidate.getType() == 30) {
            ObjectTypeNode otn;
            Map<ObjectType, ObjectTypeNode> map = context.getRuleBase().getRete().getObjectTypeNodes(context.getCurrentEntryPoint());
            if (map != null && (otn = map.get(((ObjectTypeNode)candidate).getObjectType())) != null) {
                otn.mergeExpirationOffset((ObjectTypeNode)candidate);
                node = otn;
            }
            partition = RuleBasePartitionId.MAIN_PARTITION;
        } else if (this.isSharingEnabledForNode(context, candidate)) {
            if (context.getTupleSource() != null && NodeTypeEnums.isLeftTupleSink(candidate)) {
                node = context.getTupleSource().getSinkPropagator().getMatchingNode(candidate);
            } else if (context.getObjectSource() != null && NodeTypeEnums.isObjectSink(candidate)) {
                node = context.getObjectSource().getObjectSinkPropagator().getMatchingNode(candidate);
            } else {
                throw new RuntimeException("This is a bug on node sharing verification. Please report to development team.");
            }
        }
        if (node != null && !this.areNodesCompatibleForSharing(context, node)) {
            node = null;
        }
        if (node == null) {
            node = candidate;
            if (partition == null) {
                if (context.getPartitionId() == null) {
                    context.setPartitionId(context.getRuleBase().createNewPartitionId());
                }
                partition = context.getPartitionId();
            }
            node.setPartitionId(context, partition);
            node.attach(context);
        } else {
            this.mergeNodes(node, candidate);
            context.releaseId(candidate);
            if (partition == null && context.getPartitionId() == null) {
                partition = node.getPartitionId();
                context.setPartitionId(partition);
            }
        }
        context.getNodes().add(node);
        node.addAssociation(context, context.getRule());
        return (T)node;
    }

    private void mergeNodes(BaseNode node, BaseNode duplicate) {
        if (node instanceof AlphaNode) {
            AlphaNodeFieldConstraint alphaConstraint = ((AlphaNode)node).getConstraint();
            alphaConstraint.addPackageNames(((AlphaNode)duplicate).getConstraint().getPackageNames());
            alphaConstraint.mergeEvaluationContext(((AlphaNode)duplicate).getConstraint());
        } else if (node instanceof BetaNode) {
            BetaNodeFieldConstraint[] betaConstraints = ((BetaNode)node).getConstraints();
            int i = 0;
            for (BetaNodeFieldConstraint betaConstraint : betaConstraints) {
                betaConstraint.addPackageNames(((BetaNode)duplicate).getConstraints()[i].getPackageNames());
                betaConstraint.mergeEvaluationContext(((BetaNode)duplicate).getConstraints()[i]);
                ++i;
            }
        }
    }

    private boolean isSharingEnabledForNode(BuildContext context, BaseNode node) {
        if (NodeTypeEnums.isLeftTupleSource(node)) {
            return context.getRuleBase().getRuleBaseConfiguration().isShareBetaNodes();
        }
        if (NodeTypeEnums.isObjectSource(node)) {
            return context.getRuleBase().getRuleBaseConfiguration().isShareAlphaNodes();
        }
        return false;
    }

    private boolean areNodesCompatibleForSharing(BuildContext context, BaseNode node) {
        if (node.getType() == 71) {
            String agendaGroup = context.getRule().getAgendaGroup();
            for (Rule associatedRule : node.getAssociatedRules()) {
                if (agendaGroup.equals(((RuleImpl)associatedRule).getAgendaGroup())) continue;
                return false;
            }
        }
        return true;
    }

    public BetaConstraints createBetaNodeConstraint(BuildContext context, List<BetaNodeFieldConstraint> list, boolean disableIndexing) {
        BetaConstraints constraints;
        switch (list.size()) {
            case 0: {
                constraints = EmptyBetaConstraints.getInstance();
                break;
            }
            case 1: {
                constraints = BetaNodeConstraintFactory.Factory.get().createSingleBetaConstraints(list.get(0), context.getRuleBase().getRuleBaseConfiguration(), disableIndexing);
                break;
            }
            case 2: {
                constraints = BetaNodeConstraintFactory.Factory.get().createDoubleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getRuleBaseConfiguration(), disableIndexing);
                break;
            }
            case 3: {
                constraints = BetaNodeConstraintFactory.Factory.get().createTripleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getRuleBaseConfiguration(), disableIndexing);
                break;
            }
            case 4: {
                constraints = BetaNodeConstraintFactory.Factory.get().createQuadroupleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getRuleBaseConfiguration(), disableIndexing);
                break;
            }
            default: {
                constraints = BetaNodeConstraintFactory.Factory.get().createDefaultBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getRuleBaseConfiguration(), disableIndexing);
            }
        }
        return constraints;
    }

    public TemporalDependencyMatrix calculateTemporalDistance(GroupElement groupElement) {
        ArrayList<Pattern> events = new ArrayList<Pattern>();
        this.selectAllEventPatterns(events, groupElement);
        int size = events.size();
        if (size >= 1) {
            Interval[][] result;
            Interval[][] source = new Interval[size][];
            for (int row = 0; row < size; ++row) {
                source[row] = new Interval[size];
                for (int col = 0; col < size; ++col) {
                    source[row][col] = row == col ? new Interval(0L, 0L) : new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
                }
            }
            if (size > 1) {
                ArrayList<Declaration> declarations = new ArrayList<Declaration>();
                int eventIndex = 0;
                for (Pattern event : events) {
                    declarations.add(event.getDeclaration());
                    HashMap<Declaration, Interval> temporal = new HashMap<Declaration, Interval>();
                    this.gatherTemporalRelationships(event.getConstraints(), temporal);
                    for (Map.Entry entry : temporal.entrySet()) {
                        int targetIndex = declarations.indexOf(entry.getKey());
                        Interval interval = (Interval)entry.getValue();
                        source[targetIndex][eventIndex].intersect(interval);
                        Interval reverse = new Interval(interval.getUpperBound() == Long.MAX_VALUE ? Long.MIN_VALUE : -interval.getUpperBound(), interval.getLowerBound() == Long.MIN_VALUE ? Long.MAX_VALUE : -interval.getLowerBound());
                        source[eventIndex][targetIndex].intersect(reverse);
                    }
                    ++eventIndex;
                }
                result = TimeUtils.calculateTemporalDistance(source);
            } else {
                result = source;
            }
            return new TemporalDependencyMatrix(result, events);
        }
        return null;
    }

    private void gatherTemporalRelationships(List<?> constraints, Map<Declaration, Interval> temporal) {
        for (Object obj : constraints) {
            Declaration[] decs;
            IntervalProviderConstraint constr;
            if (!(obj instanceof IntervalProviderConstraint) || !(constr = (IntervalProviderConstraint)obj).isTemporal() || (decs = constr.getRequiredDeclarations()).length <= 0 || !decs[0].isPatternDeclaration() || !decs[0].getPattern().getObjectType().isEvent()) continue;
            Declaration target = decs[0];
            Interval interval = temporal.get(target);
            if (interval == null) {
                interval = constr.getInterval();
                temporal.put(target, interval);
                continue;
            }
            interval.intersect(constr.getInterval());
        }
    }

    private void selectAllEventPatterns(List<Pattern> events, RuleConditionElement rce) {
        Pattern p;
        if (rce instanceof Pattern && (p = (Pattern)rce).getObjectType().isEvent()) {
            events.add(p);
        }
        for (RuleConditionElement ruleConditionElement : rce.getNestedElements()) {
            this.selectAllEventPatterns(events, ruleConditionElement);
        }
    }
}

