/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.definitions.impl.KnowledgePackageImpl;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.rule.ConditionalElement;
import org.drools.base.rule.DialectRuntimeData;
import org.drools.base.rule.DialectRuntimeRegistry;
import org.drools.base.rule.EvalCondition;
import org.drools.base.rule.Function;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.PredicateConstraint;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.accessor.Wireable;
import org.drools.base.rule.constraint.Constraint;
import org.drools.core.util.KeyStoreHelper;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;
import org.drools.wiring.api.ComponentsFactory;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.internal.concurrent.ExecutorProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private static final Logger LOG = LoggerFactory.getLogger(JavaDialectRuntimeData.class);
    private static final long serialVersionUID = 510L;
    private final Map<String, Wireable> invokerLookups = new ConcurrentHashMap<String, Wireable>();
    private final Map<String, byte[]> classLookups = new ConcurrentHashMap<String, byte[]>();
    private Map<String, byte[]> store = new HashMap<String, byte[]>();
    private transient ClassLoader classLoader;
    private transient ClassLoader rootClassLoader;
    private boolean dirty = false;
    private List<String> wireList = Collections.emptyList();

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        KeyStoreHelper helper = KeyStoreHelper.get();
        stream.writeBoolean(helper.isSigned());
        if (helper.isSigned()) {
            stream.writeObject(helper.getPvtKeyAlias());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeInt(this.store.size());
        for (Map.Entry<String, byte[]> entry : this.store.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.flush();
        out.close();
        byte[] buff = bos.toByteArray();
        stream.writeObject(buff);
        if (helper.isSigned()) {
            this.sign(stream, helper, buff);
        }
        stream.writeInt(this.invokerLookups.size());
        for (Map.Entry<String, Wireable> entry : this.invokerLookups.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
        stream.writeInt(this.classLookups.size());
        for (Map.Entry<String, Wireable> entry : this.classLookups.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    private void sign(ObjectOutput stream, KeyStoreHelper helper, byte[] buff) {
        try {
            stream.writeObject(helper.signDataWithPrivateKey(buff));
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing object store: " + e.getMessage(), e);
        }
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        int i;
        KeyStoreHelper helper = KeyStoreHelper.get();
        boolean signed = stream.readBoolean();
        if (helper.isSigned() != signed) {
            throw new RuntimeException("This environment is configured to work with " + (helper.isSigned() ? "signed" : "unsigned") + " serialized objects, but the given object is " + (signed ? "signed" : "unsigned") + ". Deserialization aborted.");
        }
        String pubKeyAlias = null;
        if (signed) {
            pubKeyAlias = (String)stream.readObject();
            if (helper.getPubKeyStore() == null) {
                throw new RuntimeException("The package was serialized with a signature. Please configure a public keystore with the public key to check the signature. Deserialization aborted.");
            }
        }
        byte[] bytes = (byte[])stream.readObject();
        if (signed) {
            this.checkSignature(stream, helper, bytes, pubKeyAlias);
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        int length = in.readInt();
        for (i = 0; i < length; ++i) {
            this.store.put((String)in.readObject(), (byte[])in.readObject());
        }
        in.close();
        length = stream.readInt();
        for (i = 0; i < length; ++i) {
            this.invokerLookups.put((String)stream.readObject(), (Wireable)stream.readObject());
        }
        length = stream.readInt();
        for (i = 0; i < length; ++i) {
            this.classLookups.put((String)stream.readObject(), (byte[])stream.readObject());
        }
        this.dirty = true;
    }

    private void checkSignature(ObjectInput stream, KeyStoreHelper helper, byte[] bytes, String pubKeyAlias) throws ClassNotFoundException, IOException {
        byte[] signature = (byte[])stream.readObject();
        try {
            if (!helper.checkDataWithPublicKey(pubKeyAlias, bytes, signature)) {
                throw new RuntimeException("Signature does not match serialized package. This is a security violation. Deserialisation aborted.");
            }
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid key checking signature: " + e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Error accessing Key Store: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No algorithm available: " + e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Signature Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public void onAdd(DialectRuntimeRegistry registry, ClassLoader rootClassLoader) {
        this.rootClassLoader = rootClassLoader;
        this.classLoader = this.makeClassLoader();
    }

    @Override
    public void onRemove() {
    }

    @Override
    public void onBeforeExecute() {
        if (this.isDirty()) {
            this.reload();
        } else if (!this.wireList.isEmpty()) {
            try {
                int wireListSize = this.wireList.size();
                if (wireListSize < 100) {
                    JavaDialectRuntimeData.wireAll(this.classLoader, this.invokerLookups, this.wireList);
                } else {
                    this.wireInParallel(wireListSize);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to wire up JavaDialect", e);
            }
        }
        this.wireList.clear();
    }

    private void wireInParallel(int wireListSize) throws Exception {
        int i;
        int parallelThread = Runtime.getRuntime().availableProcessors();
        CompletionService ecs = ExecutorProviderFactory.getExecutorProvider().getCompletionService();
        int size = wireListSize / parallelThread;
        for (i = 1; i <= parallelThread; ++i) {
            List<String> subList = this.wireList.subList((i - 1) * size, i == parallelThread ? wireListSize : i * size);
            ecs.submit(new WiringExecutor(this.classLoader, this.invokerLookups, subList));
        }
        for (i = 1; i <= parallelThread; ++i) {
            ecs.take().get();
        }
    }

    private static void wireAll(ClassLoader classLoader, Map<String, Wireable> invokerLookups, List<String> wireList) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (String resourceName : wireList) {
            JavaDialectRuntimeData.wire(classLoader, invokerLookups, ClassUtils.convertResourceToClassName(resourceName));
        }
    }

    @Override
    public DialectRuntimeData clone(DialectRuntimeRegistry registry, ClassLoader rootClassLoader) {
        return this.clone(registry, rootClassLoader, false);
    }

    @Override
    public DialectRuntimeData clone(DialectRuntimeRegistry registry, ClassLoader rootClassLoader, boolean excludeClasses) {
        JavaDialectRuntimeData cloneOne = new JavaDialectRuntimeData();
        cloneOne.merge(registry, this, excludeClasses);
        cloneOne.onAdd(registry, rootClassLoader);
        return cloneOne;
    }

    @Override
    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        this.merge(registry, newData, false);
    }

    @Override
    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData, boolean excludeClasses) {
        JavaDialectRuntimeData newJavaData = (JavaDialectRuntimeData)newData;
        for (String resourceName : newJavaData.getStore().keySet()) {
            if (excludeClasses && newJavaData.classLookups.containsKey(resourceName)) continue;
            this.write(resourceName, newJavaData.read(resourceName));
        }
        this.putAllInvokers(newJavaData.invokerLookups);
        if (!excludeClasses) {
            this.putAllClassDefinitions(newJavaData.classLookups);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Map<String, byte[]> getStore() {
        return this.store;
    }

    public byte[] getBytecode(String resourceName) {
        byte[] bytecode = null;
        if (this.store != null) {
            bytecode = this.store.get(resourceName);
        }
        if (bytecode == null && this.rootClassLoader instanceof ProjectClassLoader) {
            bytecode = ((ProjectClassLoader)this.rootClassLoader).getBytecode(resourceName);
        }
        return bytecode;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    @Override
    public void removeRule(KnowledgePackageImpl pkg, RuleImpl rule) {
        String consequenceName;
        if (!(rule instanceof QueryImpl) && this.remove(consequenceName = rule.getConsequence().getClass().getName())) {
            this.removeClasses(rule.getLhs());
            String sufix = StringUtils.ucFirst(rule.getConsequence().getName()) + "ConsequenceInvoker";
            this.remove(consequenceName.substring(0, consequenceName.indexOf(sufix)));
        }
    }

    @Override
    public void removeFunction(KnowledgePackageImpl pkg, Function function) {
        this.remove(pkg.getName() + "." + StringUtils.ucFirst(function.getName()));
    }

    private void removeClasses(ConditionalElement ce) {
        if (ce instanceof GroupElement) {
            GroupElement group = (GroupElement)ce;
            for (RuleConditionElement object : group.getChildren()) {
                if (object instanceof ConditionalElement) {
                    this.removeClasses((ConditionalElement)object);
                    continue;
                }
                if (!(object instanceof Pattern)) continue;
                this.removeClasses((Pattern)object);
            }
        } else if (ce instanceof EvalCondition) {
            this.remove(((EvalCondition)ce).getEvalExpression().getClass().getName());
        }
    }

    private void removeClasses(Pattern pattern) {
        for (Constraint object : pattern.getConstraints()) {
            if (!(object instanceof PredicateConstraint)) continue;
            this.remove(((PredicateConstraint)object).getPredicateExpression().getClass().getName());
        }
    }

    public byte[] read(String resourceName) {
        return this.getStore().get(resourceName);
    }

    public synchronized void write(String resourceName, byte[] clazzData) {
        if (this.getStore().put(resourceName, clazzData) != null) {
            this.dirty = true;
            if (!this.wireList.isEmpty()) {
                this.wireList.clear();
            }
        } else if (!this.dirty) {
            try {
                if (this.wireList == Collections.emptyList()) {
                    this.wireList = new ArrayList<String>();
                }
                this.wireList.add(resourceName);
            }
            catch (Exception e) {
                LOG.error("Exception", e);
                throw new RuntimeException(e);
            }
        }
    }

    private static void wire(ClassLoader classLoader, Map<String, Wireable> invokerLookups, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Wireable invoker = invokerLookups.get(className);
        if (invoker != null) {
            JavaDialectRuntimeData.wire(classLoader, className, invoker, false);
        }
    }

    private static void wire(ClassLoader classLoader, String className, Wireable invoker, boolean reload) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (reload && invoker instanceof Wireable.Immutable && ((Wireable.Immutable)invoker).isInitialized()) {
            return;
        }
        Class<?> clazz = classLoader.loadClass(className);
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        invoker.wire(clazz.newInstance());
    }

    @Override
    public boolean remove(String resourceName) {
        this.invokerLookups.remove(resourceName);
        if (this.getStore().remove(ClassUtils.convertClassToResourcePath(resourceName)) != null) {
            this.wireList.remove(resourceName);
            this.dirty = true;
            return true;
        }
        return false;
    }

    @Override
    public void reload() {
        this.classLoader = this.makeClassLoader();
        try {
            for (Map.Entry<String, Wireable> entry : this.invokerLookups.entrySet()) {
                JavaDialectRuntimeData.wire(this.classLoader, entry.getKey(), entry.getValue(), true);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationError e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.dirty = false;
    }

    public String toString() {
        return this.getClass().getName() + this.getStore().toString();
    }

    public void putInvoker(String className, Wireable invoker) {
        this.invokerLookups.put(className, invoker);
    }

    public void putAllInvokers(Map<String, Wireable> invokers) {
        this.invokerLookups.putAll(invokers);
    }

    public void putClassDefinition(String className, byte[] classDef) {
        this.classLookups.put(className, classDef);
    }

    public void putAllClassDefinitions(Map classDefinitions) {
        this.classLookups.putAll(classDefinitions);
    }

    public byte[] getClassDefinition(String className) {
        return this.classLookups.computeIfAbsent(className, name -> this.rootClassLoader instanceof ProjectClassLoader ? ((ProjectClassLoader)this.rootClassLoader).getBytecode((String)name) : null);
    }

    private ClassLoader makeClassLoader() {
        return ComponentsFactory.createPackageClassLoader(this.store, this.rootClassLoader);
    }

    private static class WiringExecutor
    implements Callable<Boolean> {
        private final ClassLoader classLoader;
        private final Map<String, Wireable> invokerLookups;
        private final List<String> wireList;

        private WiringExecutor(ClassLoader classLoader, Map<String, Wireable> invokerLookups, List<String> wireList) {
            this.classLoader = classLoader;
            this.invokerLookups = invokerLookups;
            this.wireList = wireList;
        }

        @Override
        public Boolean call() throws Exception {
            JavaDialectRuntimeData.wireAll(this.classLoader, this.invokerLookups, this.wireList);
            return true;
        }
    }
}

