/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.drl.ast.descr.AbstractClassTypeDeclarationDescr;
import org.drools.drl.ast.descr.EnumLiteralDescr;
import org.drools.drl.ast.descr.QualifiedName;

public class EnumDeclarationDescr
extends AbstractClassTypeDeclarationDescr {
    private List<EnumLiteralDescr> literals = Collections.emptyList();

    public EnumDeclarationDescr() {
        this(null);
    }

    public EnumDeclarationDescr(String typeName) {
        super(typeName);
    }

    public EnumDeclarationDescr(String typeName, String typeNamespace) {
        super(typeName, typeNamespace);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.literals = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.literals);
    }

    public String toString() {
        return "EnumDeclaration[ " + this.getType().getFullName() + " ]";
    }

    public List<EnumLiteralDescr> getLiterals() {
        return this.literals;
    }

    public void setLiterals(List<EnumLiteralDescr> literals) {
        this.literals = literals;
    }

    public void addLiteral(EnumLiteralDescr lit) {
        if (this.literals == Collections.EMPTY_LIST) {
            this.literals = new ArrayList<EnumLiteralDescr>();
        }
        this.literals.add(lit);
    }

    @Override
    public String getSuperTypeName() {
        return "Enum";
    }

    @Override
    public String getSuperTypeNamespace() {
        return "java.lang";
    }

    @Override
    public String getSupertTypeFullName() {
        return "java.lang.Enum";
    }

    @Override
    public List<QualifiedName> getSuperTypes() {
        ArrayList<QualifiedName> l = new ArrayList<QualifiedName>(1);
        l.add(new QualifiedName("Enum", "java.lang"));
        return l;
    }
}

