/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.drools.drl.ast.descr.BaseDescr;

public class LiteralDescr
extends BaseDescr {
    public static final int TYPE_NULL = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_BOOLEAN = 4;
    private static final long serialVersionUID = 510L;
    private int type;
    private String text;

    public LiteralDescr() {
    }

    public LiteralDescr(String text, int type) {
        this.text = text;
        this.type = type;
    }

    public String toString() {
        return "[LiteralValue: " + this.getValue().getClass() + " " + this.getValue() + "]";
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public Object getValue() {
        switch (this.type) {
            case 2: {
                try {
                    return DecimalFormat.getInstance(Locale.US).parse(this.getText());
                }
                catch (ParseException e) {
                    return this.getText();
                }
            }
            case 4: {
                return Boolean.valueOf(this.getText());
            }
        }
        return this.getText();
    }
}

