/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.runtime;

import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.KieBase;
import org.kie.api.internal.runtime.KieRuntimeService;
import org.kie.api.internal.runtime.KieRuntimes;
import org.kie.api.internal.utils.KieService;

public class KieRuntimeFactory {
    private final KieBase kieBase;
    private final ConcurrentHashMap<Class<?>, Object> runtimeServices = new ConcurrentHashMap();

    public static KieRuntimeFactory of(KieBase kieBase) {
        return new KieRuntimeFactory(kieBase);
    }

    private KieRuntimeFactory(KieBase kieBase) {
        this.kieBase = kieBase;
    }

    public <T> T get(Class<T> cls) {
        return (T)this.runtimeServices.computeIfAbsent(cls, this::createRuntimeInstance);
    }

    private Object createRuntimeInstance(Class<?> c) {
        KieRuntimeService kieRuntimeService = KieService.load(KieRuntimes.class).getRuntime(c);
        if (kieRuntimeService == null) {
            throw new NoSuchElementException(c.getName());
        }
        return kieRuntimeService.newKieRuntime(this.kieBase);
    }
}

