/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.util.ArrayList;
import java.util.List;
import org.drools.drl.ast.descr.AndDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ExistsDescr;
import org.drools.drl.ast.descr.NotDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drlonyaml.model.All;
import org.drools.drlonyaml.model.Base;
import org.drools.drlonyaml.model.Exists;
import org.drools.drlonyaml.model.Not;
import org.drools.drlonyaml.model.Pattern;

public class Utils {
    private static final ObjectMapper mapper;

    private Utils() {
    }

    public static Base from(BaseDescr o) {
        if (o instanceof PatternDescr) {
            PatternDescr patternDescr = (PatternDescr)o;
            return Pattern.from(patternDescr);
        }
        if (o instanceof NotDescr) {
            NotDescr notDescr = (NotDescr)o;
            return Not.from(notDescr);
        }
        if (o instanceof AndDescr) {
            AndDescr andDescr = (AndDescr)o;
            return All.from(andDescr);
        }
        if (o instanceof ExistsDescr) {
            ExistsDescr existsDescr = (ExistsDescr)o;
            return Exists.from(existsDescr);
        }
        throw new UnsupportedOperationException("TODO: " + o);
    }

    public static List<Base> from(List<BaseDescr> descrs) {
        ArrayList<Base> results = new ArrayList<Base>();
        for (BaseDescr item : descrs) {
            results.add(Utils.from(item));
        }
        return results;
    }

    public static ObjectMapper getYamlMapper() {
        return mapper;
    }

    static {
        YAMLFactory yamlFactory = YAMLFactory.builder().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).build();
        mapper = new ObjectMapper((JsonFactory)yamlFactory);
    }
}

