/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drlonyaml.model.DrlPackage;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmokeTest {
    private static final Logger LOG = LoggerFactory.getLogger(SmokeTest.class);
    private static final DrlParser drlParser = new DrlParser();
    private static final ObjectMapper mapper;

    private void assertDrlToYamlAndBack(String filename) {
        try {
            String content = Files.readString(Paths.get(this.getClass().getResource(filename).toURI()));
            ((AbstractStringAssert)Assertions.assertThat((String)content).as("Failed to read test resource", new Object[0])).isNotNull();
            PackageDescr pkgDescr = drlParser.parse((Reader)new StringReader(content));
            ((ObjectAssert)Assertions.assertThat((Object)pkgDescr).as("Failed to parse DRL as a PackageDescr", new Object[0])).isNotNull();
            DrlPackage model = DrlPackage.from((PackageDescr)pkgDescr);
            ((ObjectAssert)Assertions.assertThat((Object)model).as("Failed to generate from a PackageDescr a valid model", new Object[0])).isNotNull();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)model);
            String yaml = writer.toString();
            writer.close();
            LOG.debug("{}", (Object)yaml);
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)yaml).as("resulting YAML shall not be null nor empty", new Object[0])).isNotNull()).isNotEmpty();
            DrlPackage deserPackage = (DrlPackage)mapper.readValue(yaml, DrlPackage.class);
            Assertions.assertThat((Object)deserPackage).usingRecursiveComparison().isEqualTo((Object)model);
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed to roundtrip from DRL to YAML and back to YAML", (Throwable)e);
        }
    }

    @Test
    public void smokeTestFromDRL1() {
        String filename = "/smoketests/smoke1.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL2() {
        String filename = "/smoketests/smoke2.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL3() {
        String filename = "/smoketests/smoke3.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL4() {
        String filename = "/smoketests/smoke4.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL5() {
        String filename = "/smoketests/smoke5.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL6() {
        String filename = "/smoketests/smoke6.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL7() {
        String filename = "/smoketests/smoke7.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL8() {
        String filename = "/smoketests/smoke8.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL9() {
        String filename = "/smoketests/smoke9.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromDRL10() {
        String filename = "/smoketests/smoke10.drl.txt";
        this.assertDrlToYamlAndBack(filename);
    }

    @Test
    public void smokeTestFromYAML1() throws Exception {
        String content = Files.readString(Paths.get(this.getClass().getResource("/smoketests/yamlfirst_smoke1.yml").toURI()));
        DrlPackage result = (DrlPackage)mapper.readValue(content, DrlPackage.class);
        LOG.debug("{}", (Object)result);
    }

    @Ignore(value="additional RHS types not supported at the moment.")
    @Test
    public void smokeTestFromYAML2() throws Exception {
        String content = Files.readString(Paths.get(this.getClass().getResource("/smoketests/yamlfirst_smoke2.yml").toURI()));
        DrlPackage result = (DrlPackage)mapper.readValue(content, DrlPackage.class);
        LOG.debug("{}", (Object)result);
    }

    static {
        YAMLFactory yamlFactory = YAMLFactory.builder().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).build();
        mapper = new ObjectMapper((JsonFactory)yamlFactory);
    }
}

