/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MethodScope
extends MemberScope<ResolvedMethod, Method> {
    private final LazyValue<FieldScope> getterField = new LazyValue<FieldScope>(this::doFindGetterField);

    protected MethodScope(ResolvedMethod method, ResolvedTypeWithMembers declaringTypeMembers, TypeContext context) {
        this(method, (ResolvedType)null, (String)null, declaringTypeMembers, (Integer)null, context);
    }

    protected MethodScope(ResolvedMethod method, ResolvedType overriddenType, String overriddenName, ResolvedTypeWithMembers declaringTypeMembers, Integer fakeContainerItemIndex, TypeContext context) {
        super(method, overriddenType, overriddenName, declaringTypeMembers, fakeContainerItemIndex, context);
    }

    public MethodScope withOverriddenType(ResolvedType overriddenType) {
        return new MethodScope((ResolvedMethod)this.getMember(), overriddenType, this.getOverriddenName(), this.getDeclaringTypeMembers(), this.getFakeContainerItemIndex(), this.getContext());
    }

    public MethodScope withOverriddenName(String overriddenName) {
        return new MethodScope((ResolvedMethod)this.getMember(), this.getOverriddenType(), overriddenName, this.getDeclaringTypeMembers(), this.getFakeContainerItemIndex(), this.getContext());
    }

    public MethodScope asFakeContainerItemScope() {
        return (MethodScope)super.asFakeContainerItemScope();
    }

    public boolean isVoid() {
        return this.getType() == null;
    }

    public int getArgumentCount() {
        return ((ResolvedMethod)this.getMember()).getArgumentCount();
    }

    public List<ResolvedType> getArgumentTypes() {
        return IntStream.range(0, this.getArgumentCount()).mapToObj(((ResolvedMethod)this.getMember())::getArgumentType).collect(Collectors.toList());
    }

    public FieldScope findGetterField() {
        return this.getterField.get();
    }

    private FieldScope doFindGetterField() {
        if (this.getType() == null || !this.isPublic() || this.getArgumentCount() > 0) {
            return null;
        }
        String methodName = this.getDeclaredName();
        String fieldName = methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : (methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) ? methodName.substring(2, 3).toLowerCase() + methodName.substring(3) : null);
        if (fieldName == null) {
            return null;
        }
        return Stream.of(this.getDeclaringTypeMembers().getMemberFields()).filter(memberField -> memberField.getName().equals(fieldName)).findFirst().map(field -> this.getContext().createFieldScope((ResolvedField)field, this.getDeclaringTypeMembers())).orElse(null);
    }

    public boolean isGetter() {
        return this.findGetterField() != null;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        A annotation = super.getAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null) {
            List<Annotation> annotationList = Arrays.asList(((Method)this.getRawMember()).getAnnotatedReturnType().getAnnotations());
            annotation = this.getContext().getAnnotationFromList(annotationClass, annotationList, considerOtherAnnotation);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotation(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        AnnotatedType annotatedReturnType = ((Method)this.getRawMember()).getAnnotatedReturnType();
        return this.getContext().getTypeParameterAnnotation(annotationClass, considerOtherAnnotation, annotatedReturnType, this.getFakeContainerItemIndex());
    }

    @Override
    public <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        A annotation = this.getAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null) {
            FieldScope associatedField = this.findGetterField();
            annotation = associatedField == null ? null : associatedField.getAnnotation(annotationClass, considerOtherAnnotation);
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        A annotation = this.getContainerItemAnnotation(annotationClass, considerOtherAnnotation);
        if (annotation == null) {
            FieldScope associatedField = this.findGetterField();
            annotation = associatedField == null ? null : ((MemberScope)associatedField).getContainerItemAnnotation(annotationClass, considerOtherAnnotation);
        }
        return annotation;
    }

    @Override
    protected String doGetSchemaPropertyName() {
        String result = this.getName();
        if (this.getContext().isDerivingFieldsFromArgumentFreeMethods() && this.getArgumentCount() == 0) {
            if (this.getOverriddenName() == null) {
                result = result.startsWith("get") && result.length() > 3 ? Character.toLowerCase(result.charAt(3)) + result.substring(4) : (result.startsWith("is") && result.length() > 2 ? Character.toLowerCase(result.charAt(2)) + result.substring(3) : result + "()");
            }
        } else {
            result = result + this.getArgumentTypes().stream().map(this.getContext()::getMethodPropertyArgumentTypeDescription).collect(Collectors.joining(", ", "(", ")"));
        }
        return result;
    }
}

