/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SchemaCleanUpUtils {
    private final SchemaGeneratorConfig config;

    public SchemaCleanUpUtils(SchemaGeneratorConfig config) {
        this.config = config;
    }

    public void reduceAllOfNodes(List<ObjectNode> jsonSchemas) {
        String allOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ALLOF);
        Map<String, SchemaKeyword> reverseTagMap = SchemaKeyword.getReverseTagMap(this.config.getSchemaVersion(), _tag -> true);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.mergeAllOfPartsIfPossible((JsonNode)nodeToCheck, allOfTagName, reverseTagMap));
    }

    public void reduceAnyOfNodes(List<ObjectNode> jsonSchemas) {
        String anyOfTagName = this.config.getKeyword(SchemaKeyword.TAG_ANYOF);
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.reduceAnyOfWrappersIfPossible((JsonNode)nodeToCheck, anyOfTagName));
    }

    public void setStrictTypeInfo(List<ObjectNode> jsonSchemas, boolean considerNullType) {
        String typeTagName = this.config.getKeyword(SchemaKeyword.TAG_TYPE);
        Map<String, SchemaKeyword> reverseTagMap = SchemaKeyword.getReverseTagMap(this.config.getSchemaVersion(), tag -> !tag.getImpliedTypes().isEmpty());
        this.finaliseSchemaParts(jsonSchemas, nodeToCheck -> this.addTypeInfoWhereMissing((ObjectNode)nodeToCheck, typeTagName, considerNullType, reverseTagMap));
    }

    private Set<String> getTagNamesSupporting(SchemaKeyword.TagContent contentType) {
        return SchemaKeyword.getReverseTagMap(this.config.getSchemaVersion(), tag -> tag.supportsContentType(contentType)).keySet();
    }

    private void finaliseSchemaParts(List<ObjectNode> schemaNodes, Consumer<ObjectNode> performCleanUpOnSingleSchemaNode) {
        ArrayList<ObjectNode> nextNodesToCheck = new ArrayList<ObjectNode>(schemaNodes);
        Consumer<JsonNode> addNodeToCheck = node -> {
            if (node instanceof ObjectNode) {
                nextNodesToCheck.add((ObjectNode)node);
            }
        };
        Set<String> tagsWithSchemas = this.getTagNamesSupporting(SchemaKeyword.TagContent.SCHEMA);
        Set<String> tagsWithSchemaArrays = this.getTagNamesSupporting(SchemaKeyword.TagContent.ARRAY_OF_SCHEMAS);
        Set<String> tagsWithSchemaObjects = this.getTagNamesSupporting(SchemaKeyword.TagContent.NAMED_SCHEMAS);
        do {
            ArrayList<ObjectNode> currentNodesToCheck = new ArrayList<ObjectNode>(nextNodesToCheck);
            nextNodesToCheck.clear();
            for (ObjectNode nodeToCheck : currentNodesToCheck) {
                performCleanUpOnSingleSchemaNode.accept(nodeToCheck);
                tagsWithSchemas.stream().map(nodeToCheck::get).forEach(addNodeToCheck);
                tagsWithSchemaArrays.stream().map(nodeToCheck::get).filter(ArrayNode.class::isInstance).forEach(arrayNode -> arrayNode.forEach(addNodeToCheck));
                tagsWithSchemaObjects.stream().map(nodeToCheck::get).filter(ObjectNode.class::isInstance).forEach(objectNode -> objectNode.forEach(addNodeToCheck));
            }
        } while (!nextNodesToCheck.isEmpty());
    }

    private void mergeAllOfPartsIfPossible(JsonNode schemaNode, String allOfTagName, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        ObjectNode schemaObjectNode = (ObjectNode)schemaNode;
        JsonNode allOfTag = schemaObjectNode.get(allOfTagName);
        if (!(allOfTag instanceof ArrayNode)) {
            return;
        }
        allOfTag.forEach(part -> this.mergeAllOfPartsIfPossible((JsonNode)part, allOfTagName, reverseKeywordMap));
        ArrayList<JsonNode> allParts = new ArrayList<JsonNode>(1 + allOfTag.size());
        allParts.add(schemaObjectNode);
        allOfTag.forEach(allParts::add);
        Supplier<ObjectNode> successfulMergeResultSupplier = this.mergeSchemas(schemaObjectNode, allParts, reverseKeywordMap);
        if (successfulMergeResultSupplier == null) {
            return;
        }
        schemaObjectNode.remove(allOfTagName);
        schemaObjectNode.setAll(successfulMergeResultSupplier.get());
    }

    private Supplier<? extends JsonNode> getAllOfMergeFunctionFor(SchemaKeyword keyword, List<JsonNode> valuesToMerge, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (valuesToMerge.size() == 1) {
            return () -> (JsonNode)valuesToMerge.get(0);
        }
        switch (keyword) {
            case TAG_ALLOF: 
            case TAG_REQUIRED: {
                return this.mergeArrays(valuesToMerge);
            }
            case TAG_PROPERTIES: 
            case TAG_DEPENDENT_SCHEMAS: {
                if (this.config.getSchemaVersion() == SchemaVersion.DRAFT_6 || this.config.getSchemaVersion() == SchemaVersion.DRAFT_7) {
                    return Optional.ofNullable(this.mergeDependentRequiredNode(valuesToMerge)).orElseGet(() -> this.mergeObjectProperties(valuesToMerge));
                }
                return this.mergeObjectProperties(valuesToMerge);
            }
            case TAG_DEPENDENT_REQUIRED: {
                return this.mergeDependentRequiredNode(valuesToMerge);
            }
            case TAG_ITEMS: 
            case TAG_UNEVALUATED_ITEMS: 
            case TAG_ADDITIONAL_PROPERTIES: 
            case TAG_UNEVALUATED_PROPERTIES: {
                return this.mergeSchemas(null, valuesToMerge, reverseKeywordMap);
            }
            case TAG_TYPE: {
                return this.returnOverlapOfStringsOrStringArrays(valuesToMerge);
            }
            case TAG_ITEMS_MAX: 
            case TAG_PROPERTIES_MAX: 
            case TAG_MAXIMUM: 
            case TAG_MAXIMUM_EXCLUSIVE: 
            case TAG_LENGTH_MAX: {
                return this.returnMinimumNumericValue(valuesToMerge);
            }
            case TAG_ITEMS_MIN: 
            case TAG_PROPERTIES_MIN: 
            case TAG_MINIMUM: 
            case TAG_MINIMUM_EXCLUSIVE: 
            case TAG_LENGTH_MIN: {
                return this.returnMaximumNumericValue(valuesToMerge);
            }
        }
        return this.returnOneIfAllEqual(valuesToMerge);
    }

    private Supplier<JsonNode> mergeArrays(List<JsonNode> arrayNodesToMerge) {
        if (!arrayNodesToMerge.stream().allMatch(JsonNode::isArray)) {
            return null;
        }
        return () -> {
            ArrayNode mergedArrayNode = this.config.createArrayNode();
            arrayNodesToMerge.forEach(node -> node.forEach(mergedArrayNode::add));
            return mergedArrayNode;
        };
    }

    private Supplier<JsonNode> mergeObjectProperties(List<JsonNode> objectNodesToMerge) {
        if (!objectNodesToMerge.stream().allMatch(JsonNode::isObject)) {
            return null;
        }
        ObjectNode mergedObjectNode = this.config.createObjectNode();
        for (JsonNode singleObjectNode : objectNodesToMerge) {
            Iterator<Map.Entry<String, JsonNode>> it = singleObjectNode.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> singleField = it.next();
                if (!mergedObjectNode.has(singleField.getKey())) {
                    mergedObjectNode.set(singleField.getKey(), singleField.getValue());
                    continue;
                }
                if (mergedObjectNode.get(singleField.getKey()).equals(singleField.getValue())) continue;
                return null;
            }
        }
        return () -> mergedObjectNode;
    }

    private Supplier<JsonNode> mergeDependentRequiredNode(List<JsonNode> dependentRequiredNodesToMerge) {
        if (!dependentRequiredNodesToMerge.stream().allMatch(JsonNode::isObject)) {
            return null;
        }
        LinkedHashMap<String, Set> mergedDependentRequiredNames = new LinkedHashMap<String, Set>();
        for (JsonNode singleDependentRequired : dependentRequiredNodesToMerge) {
            Iterator<Map.Entry<String, JsonNode>> it = singleDependentRequired.fields();
            while (it.hasNext()) {
                Map.Entry<String, JsonNode> singleLeadingField = it.next();
                if (!singleLeadingField.getValue().isArray()) {
                    return null;
                }
                Set propertyNames = mergedDependentRequiredNames.computeIfAbsent(singleLeadingField.getKey(), name -> new LinkedHashSet());
                Iterator<JsonNode> propertyNameIt = singleLeadingField.getValue().elements();
                while (propertyNameIt.hasNext()) {
                    JsonNode propertyName = propertyNameIt.next();
                    if (!propertyName.isTextual()) {
                        return null;
                    }
                    propertyNames.add(propertyName.asText());
                }
            }
        }
        return () -> {
            ObjectNode mergedDependentRequiredNode = this.config.createObjectNode();
            mergedDependentRequiredNames.forEach((leadName, dependentNames) -> dependentNames.forEach(mergedDependentRequiredNode.withArray((String)leadName)::add));
            return mergedDependentRequiredNode;
        };
    }

    private Supplier<ObjectNode> mergeSchemas(ObjectNode mainNodeIncludingAllOf, List<JsonNode> nodes, Map<String, SchemaKeyword> reverseKeywordMap) {
        if (nodes.stream().anyMatch(part -> !(part instanceof ObjectNode) && (!part.isBoolean() || !part.asBoolean()))) {
            return null;
        }
        List parts = nodes.stream().filter(ObjectNode.class::isInstance).map(ObjectNode.class::cast).collect(Collectors.toList());
        Map fieldsFromAllParts = parts.stream().flatMap(part -> StreamSupport.stream(((Iterable)part::fields).spliterator(), false)).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        if ((this.config.getSchemaVersion() == SchemaVersion.DRAFT_6 || this.config.getSchemaVersion() == SchemaVersion.DRAFT_7) && fieldsFromAllParts.containsKey(this.config.getKeyword(SchemaKeyword.TAG_REF)) && (mainNodeIncludingAllOf == null ? parts.size() > 1 : mainNodeIncludingAllOf.size() > 1 || parts.size() > 2)) {
            return null;
        }
        Map unsupportedTagValues = fieldsFromAllParts.entrySet().stream().filter(entry -> !reverseKeywordMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, SchemaCleanUpUtils::throwingMerger, LinkedHashMap::new));
        if (unsupportedTagValues.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).size() > 1)) {
            return null;
        }
        Map<SchemaKeyword, Supplier<? extends JsonNode>> supportedTagValueSuppliers = this.collectSupportedTagValueSuppliers(fieldsFromAllParts, reverseKeywordMap, mainNodeIncludingAllOf);
        if (supportedTagValueSuppliers == null) {
            return null;
        }
        return () -> {
            ObjectNode mergedNode = this.config.createObjectNode();
            supportedTagValueSuppliers.forEach((keyword, valueSupplier) -> mergedNode.set(this.config.getKeyword((SchemaKeyword)((Object)((Object)keyword))), (JsonNode)valueSupplier.get()));
            unsupportedTagValues.forEach((tagName, valueList) -> mergedNode.set((String)tagName, (JsonNode)valueList.get(0)));
            return mergedNode;
        };
    }

    private Map<SchemaKeyword, Supplier<? extends JsonNode>> collectSupportedTagValueSuppliers(Map<String, List<JsonNode>> fieldsFromAllParts, Map<String, SchemaKeyword> reverseKeywordMap, ObjectNode mainNodeIncludingAllOf) {
        Map supportedTagValues = fieldsFromAllParts.entrySet().stream().filter(entry -> reverseKeywordMap.containsKey(entry.getKey())).collect(Collectors.toMap(entry -> (SchemaKeyword)((Object)((Object)reverseKeywordMap.get(entry.getKey()))), Map.Entry::getValue, SchemaCleanUpUtils::throwingMerger, LinkedHashMap::new));
        if (supportedTagValues.containsKey((Object)SchemaKeyword.TAG_IF)) {
            return null;
        }
        LinkedHashMap<SchemaKeyword, Supplier<? extends JsonNode>> supportedTagValueSuppliers = new LinkedHashMap<SchemaKeyword, Supplier<? extends JsonNode>>();
        for (Map.Entry fieldEntries : supportedTagValues.entrySet()) {
            SchemaKeyword keyword = (SchemaKeyword)((Object)fieldEntries.getKey());
            List valuesToMerge = (List)fieldEntries.getValue();
            if (keyword == SchemaKeyword.TAG_ALLOF && mainNodeIncludingAllOf != null && (valuesToMerge = valuesToMerge.subList(1, valuesToMerge.size())).isEmpty()) continue;
            Supplier<? extends JsonNode> mergeResultSupplier = this.getAllOfMergeFunctionFor(keyword, valuesToMerge, reverseKeywordMap);
            if (mergeResultSupplier == null) {
                return null;
            }
            supportedTagValueSuppliers.put(keyword, mergeResultSupplier);
        }
        return supportedTagValueSuppliers;
    }

    private Supplier<JsonNode> returnOverlapOfStringsOrStringArrays(List<JsonNode> nodes) {
        List<String> encounteredValues = this.getStringValuesFromStringOrStringArray(nodes.get(0));
        if (encounteredValues == null) {
            return null;
        }
        for (JsonNode nextNode : nodes.subList(1, nodes.size())) {
            List<String> nextValues = this.getStringValuesFromStringOrStringArray(nextNode);
            if (nextValues == null) {
                return null;
            }
            encounteredValues.retainAll(nextValues);
            if (!encounteredValues.isEmpty()) continue;
            return null;
        }
        if (encounteredValues.size() == 1) {
            return () -> new TextNode((String)encounteredValues.get(0));
        }
        return () -> this.config.createArrayNode().addAll(encounteredValues.stream().map(TextNode::new).collect(Collectors.toList()));
    }

    private List<String> getStringValuesFromStringOrStringArray(JsonNode node) {
        if (node.isArray()) {
            ArrayList<String> result = new ArrayList<String>();
            node.forEach(arrayItem -> result.add(arrayItem.asText(null)));
            if (result.contains(null)) {
                return null;
            }
            return result;
        }
        if (node.isTextual()) {
            return Collections.singletonList(node.asText());
        }
        return null;
    }

    private Supplier<JsonNode> returnMinimumNumericValue(List<JsonNode> nodes) {
        if (nodes.stream().allMatch(JsonNode::isNumber)) {
            return () -> nodes.stream().reduce((a, b) -> a.asDouble() < b.asDouble() ? a : b).orElse(null);
        }
        return null;
    }

    private Supplier<JsonNode> returnMaximumNumericValue(List<JsonNode> nodes) {
        if (nodes.stream().allMatch(JsonNode::isNumber)) {
            return () -> nodes.stream().reduce((a, b) -> a.asDouble() < b.asDouble() ? b : a).orElse(null);
        }
        return null;
    }

    private Supplier<JsonNode> returnOneIfAllEqual(List<JsonNode> nodes) {
        JsonNode firstNode = nodes.get(0);
        if (nodes.subList(1, nodes.size()).stream().allMatch(firstNode::equals)) {
            return () -> firstNode;
        }
        return null;
    }

    private void reduceAnyOfWrappersIfPossible(JsonNode schemaNode, String anyOfTagName) {
        if (!(schemaNode instanceof ObjectNode)) {
            return;
        }
        JsonNode anyOfTag = schemaNode.get(anyOfTagName);
        if (!(anyOfTag instanceof ArrayNode)) {
            return;
        }
        anyOfTag.forEach(part -> this.reduceAnyOfWrappersIfPossible((JsonNode)part, anyOfTagName));
        for (int index = anyOfTag.size() - 1; index > -1; --index) {
            JsonNode nestedAnyOf;
            JsonNode arrayEntry = anyOfTag.get(index);
            if (!(arrayEntry instanceof ObjectNode) || arrayEntry.size() != 1 || !((nestedAnyOf = arrayEntry.get(anyOfTagName)) instanceof ArrayNode)) continue;
            ((ArrayNode)anyOfTag).remove(index);
            for (int nestedEntryIndex = nestedAnyOf.size() - 1; nestedEntryIndex > -1; --nestedEntryIndex) {
                ((ArrayNode)anyOfTag).insert(index, nestedAnyOf.get(nestedEntryIndex));
            }
        }
    }

    private void addTypeInfoWhereMissing(ObjectNode schemaNode, String typeTagName, boolean considerNullType, Map<String, SchemaKeyword> reverseTagMap) {
        if (schemaNode.has(typeTagName)) {
            return;
        }
        List<String> impliedTypes = reverseTagMap.entrySet().stream().filter(entry -> schemaNode.has((String)entry.getKey())).flatMap(entry -> ((SchemaKeyword)((Object)((Object)entry.getValue()))).getImpliedTypes().stream()).distinct().sorted().map(SchemaKeyword.SchemaType::getSchemaKeywordValue).collect(Collectors.toList());
        if (impliedTypes.isEmpty()) {
            return;
        }
        if (considerNullType) {
            impliedTypes.add(SchemaKeyword.SchemaType.NULL.getSchemaKeywordValue());
        }
        if (impliedTypes.size() == 1) {
            schemaNode.put(typeTagName, (String)impliedTypes.get(0));
        } else {
            impliedTypes.forEach(schemaNode.putArray(typeTagName)::add);
        }
    }

    public String ensureDefinitionKeyIsUriCompatible(String definitionKey) {
        return definitionKey.replaceAll("\\[\\]", "*").replaceAll("<", "(").replaceAll(">", ")").replaceAll("[^a-zA-Z0-9\\.\\-_\\$\\*\\(\\),]+", "");
    }

    public String ensureDefinitionKeyIsPlain(String definitionKey) {
        return definitionKey.replaceAll("\\$", "-").replaceAll("\\[\\]", "...").replaceAll("[<>]", "_").replaceAll(",", ".").replaceAll("[^a-zA-Z0-9\\.\\-_]+", "");
    }

    private static <T> T throwingMerger(T one, T two) {
        throw new IllegalStateException("Duplicate key " + one);
    }
}

