/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.cdss;

import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.examples.cdss.data.Diagnose;
import org.drools.examples.cdss.data.Patient;
import org.drools.examples.cdss.data.Recommendation;
import org.drools.examples.cdss.service.RecommendationService;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;

public class CDSSExample {
    public static final void main(String[] args) {
        try {
            KnowledgeBase kbase = CDSSExample.readRule();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"log/cdss");
            RecommendationService recommendationService = new RecommendationService();
            ksession.setGlobal("recommendationService", (Object)recommendationService);
            Patient patient = new Patient();
            patient.setName("John Doe");
            patient.setAge(20);
            ksession.insert((Object)patient);
            Diagnose diagnose = new Diagnose("Diagnose disease X");
            ksession.insert((Object)diagnose);
            ksession.fireAllRules();
            List<Recommendation> recommendations = recommendationService.getRecommendations();
            for (Recommendation recommendation : recommendations) {
                System.out.println(recommendation);
            }
            recommendations.clear();
            diagnose = new Diagnose("Diagnose disease X: Type unknown");
            ksession.insert((Object)diagnose);
            ksession.fireAllRules();
            recommendations = recommendationService.getRecommendations();
            for (Recommendation recommendation : recommendations) {
                System.out.println(recommendation);
            }
            recommendations.clear();
            diagnose = new Diagnose("Diagnose disease X: Type 2");
            ksession.insert((Object)diagnose);
            ksession.fireAllRules();
            logger.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase readRule() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/cdss/GenericRules.drl", CDSSExample.class), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/cdss/GenericRules.drl", CDSSExample.class), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/cdss/ClinicalPathwayX.rf", CDSSExample.class), ResourceType.DRF);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/cdss/ClinicalPathwayX.drl", CDSSExample.class), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/cdss/TreatmentX.rf", CDSSExample.class), ResourceType.DRF);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/cdss/TreatmentY.rf", CDSSExample.class), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

