/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku.rules;

import org.drools.examples.sudoku.swing.SudokuGridModel;

public abstract class AbstractCellValue {
    private int value;
    private int row;
    private int col;
    private int zone;

    protected AbstractCellValue(int value, int row, int col) {
        this.value = value;
        this.row = row;
        this.col = col;
        this.zone = this.deriveZone(row, col);
    }

    protected AbstractCellValue(AbstractCellValue cellValue) {
        this(cellValue.getValue(), cellValue.getRow(), cellValue.getCol());
    }

    private int deriveZone(int row, int col) {
        return SudokuGridModel.ZONE_LOOKUP[row][col];
    }

    public int getValue() {
        return this.value;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public int getZone() {
        return this.zone;
    }
}

