/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.drools.KnowledgeBase;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.ObjectUpdatedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.examples.sudoku.rules.AbstractCellValue;
import org.drools.examples.sudoku.rules.DroolsUtil;
import org.drools.examples.sudoku.rules.PossibleCellValue;
import org.drools.examples.sudoku.rules.ResolvedCellValue;
import org.drools.examples.sudoku.swing.AbstractSudokuGridModel;
import org.drools.examples.sudoku.swing.SudokuGridEvent;
import org.drools.examples.sudoku.swing.SudokuGridModel;
import org.drools.runtime.StatefulKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsSudokuGridModel
extends AbstractSudokuGridModel
implements SudokuGridModel {
    public static final String SUDOKU_SOLVER_DRL = "../sudokuSolver.drl";
    public static final String SUDOKU_VALIDATOR_DRL = "../sudokuValidator.drl";
    private Set<AbstractCellValue> allCellValues = new HashSet<AbstractCellValue>();
    private Set<Integer>[][] cellValuesByRowAndCol = new HashSet[9][9];
    private KnowledgeBase solverRuleBase;
    private StatefulKnowledgeSession solverStatefulSession;
    private SudokuWorkingMemoryListener workingMemoryListener = new SudokuWorkingMemoryListener();

    public DroolsSudokuGridModel() {
    }

    public DroolsSudokuGridModel(Integer[][] cellValues) {
        this();
        this.setCellValues(cellValues);
    }

    @Override
    public void setCellValues(Integer[][] cellValues) {
        long startTime = System.currentTimeMillis();
        if (this.solverRuleBase == null) {
            try {
                this.solverRuleBase = DroolsUtil.getInstance().readRuleBase(SUDOKU_SOLVER_DRL);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("Error Reading RuleBase for Solver");
            }
        }
        if (this.solverStatefulSession != null) {
            this.solverStatefulSession.removeEventListener((WorkingMemoryEventListener)this.workingMemoryListener);
        }
        this.solverStatefulSession = this.solverRuleBase.newStatefulKnowledgeSession();
        this.solverStatefulSession.addEventListener((WorkingMemoryEventListener)this.workingMemoryListener);
        for (int row = 0; row < cellValues.length; ++row) {
            for (int col = 0; col < cellValues[row].length; ++col) {
                this.cellValuesByRowAndCol[row][col] = new HashSet<Integer>();
                if (cellValues[row][col] == null) {
                    for (int value = 1; value < 10; ++value) {
                        PossibleCellValue cellValue = new PossibleCellValue(value, row, col);
                        this.addCellValue(cellValue);
                        this.allCellValues.add(cellValue);
                    }
                    continue;
                }
                ResolvedCellValue cellValue = new ResolvedCellValue(cellValues[row][col], row, col);
                this.addCellValue(cellValue);
            }
        }
        this.insertAllCellValues(this.solverStatefulSession);
        System.out.println("Setting up working memory and inserting all cell value POJOs took " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public boolean isCellResolved(int row, int col) {
        return this.getPossibleCellValues(row, col).size() == 1;
    }

    @Override
    public boolean isGridSolved() {
        boolean solved = true;
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                if (this.isCellResolved(row, col)) continue;
                System.out.print("(" + row + "," + col + ") has not been resolved but has been narrowed down to ");
                for (Integer possibleInt : this.getPossibleCellValues(row, col)) {
                    System.out.print(possibleInt + " ");
                }
                System.out.println();
                solved = false;
            }
        }
        if (solved) {
            try {
                KnowledgeBase kbase = DroolsUtil.getInstance().readRuleBase(SUDOKU_VALIDATOR_DRL);
                StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
                ArrayList issues = new ArrayList();
                ksession.setGlobal("issues", issues);
                this.insertAllCellValues(ksession);
                ksession.fireAllRules();
                if (issues.isEmpty()) {
                    System.out.println("Sucessfully Validated Solution");
                } else {
                    solved = false;
                    for (Object issue : issues) {
                        System.out.println(issue);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException();
            }
        }
        return solved;
    }

    @Override
    public Set<Integer> getPossibleCellValues(int row, int col) {
        return this.cellValuesByRowAndCol[row][col];
    }

    @Override
    public boolean solve() {
        this.solverStatefulSession.fireAllRules();
        return this.isGridSolved();
    }

    public boolean step() {
        this.solverStatefulSession.fireAllRules();
        return this.isGridSolved();
    }

    private void insertAllCellValues(StatefulKnowledgeSession statefulSession) {
        for (AbstractCellValue cellValue : this.allCellValues) {
            statefulSession.insert((Object)cellValue);
        }
    }

    private void addCellValue(AbstractCellValue cellValue) {
        this.allCellValues.add(cellValue);
        this.cellValuesByRowAndCol[cellValue.getRow()][cellValue.getCol()].add(cellValue.getValue());
    }

    private void removeCellValue(AbstractCellValue cellValue) {
        this.allCellValues.remove(cellValue);
        this.cellValuesByRowAndCol[cellValue.getRow()][cellValue.getCol()].remove(cellValue.getValue());
    }

    class SudokuWorkingMemoryListener
    implements WorkingMemoryEventListener {
        SudokuWorkingMemoryListener() {
        }

        public void objectInserted(ObjectInsertedEvent ev) {
            if (ev.getObject() instanceof AbstractCellValue) {
                DroolsSudokuGridModel.this.addCellValue((AbstractCellValue)ev.getObject());
            }
            if (ev.getObject() instanceof ResolvedCellValue) {
                ResolvedCellValue cellValue = (ResolvedCellValue)ev.getObject();
                DroolsSudokuGridModel.this.fireCellResolvedEvent(new SudokuGridEvent(this, cellValue.getRow(), cellValue.getCol(), cellValue.getValue()));
            }
            if (ev.getObject() instanceof String) {
                System.out.println(ev.getObject());
            }
        }

        public void objectRetracted(ObjectRetractedEvent ev) {
            if (ev.getOldObject() instanceof AbstractCellValue) {
                AbstractCellValue cellValue = (AbstractCellValue)ev.getOldObject();
                DroolsSudokuGridModel.this.removeCellValue(cellValue);
                DroolsSudokuGridModel.this.fireCellUpdatedEvent(new SudokuGridEvent(this, cellValue.getRow(), cellValue.getCol(), cellValue.getValue()));
            }
        }

        public void objectUpdated(ObjectUpdatedEvent ev) {
            if (ev.getObject() instanceof ResolvedCellValue) {
                ResolvedCellValue cellValue = (ResolvedCellValue)ev.getObject();
                DroolsSudokuGridModel.this.fireCellUpdatedEvent(new SudokuGridEvent(this, cellValue.getRow(), cellValue.getCol(), cellValue.getValue()));
            }
        }
    }
}

