/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.examples.templates.ActivityType;
import org.drools.examples.templates.FeeScheduleRule;
import org.drools.examples.templates.FeeScheduleType;
import org.drools.examples.templates.FeeType;
import org.drools.examples.templates.ProductType;
import org.drools.template.DataProvider;
import org.drools.template.DataProviderCompiler;

public class DataDrivenTemplateExample {
    public static void main(String[] args) throws Exception {
        DataDrivenTemplateExample example = new DataDrivenTemplateExample();
        example.testCompiler();
    }

    public void testCompiler() throws Exception {
        ArrayList<FeeScheduleRule> rules = new ArrayList<FeeScheduleRule>();
        FeeScheduleType standard = new FeeScheduleType("STANDARD");
        FeeScheduleType flat = new FeeScheduleType("FLAT");
        ProductType sblc = new ProductType("SBLC");
        ProductType rrc = new ProductType("RRC");
        ActivityType iss = new ActivityType("ISS");
        ActivityType osx = new ActivityType("OSX");
        FeeType commission = new FeeType("Commission");
        FeeType postage = new FeeType("Postage");
        FeeType telex = new FeeType("Telex");
        rules.add(this.createRule(1L, flat, "", sblc, iss, commission, "Party 1", "USD", "", 0L, 750L, true));
        rules.add(this.createRule(2L, standard, "Entity Branch 1", rrc, iss, commission, "", "YEN", "", 0L, 1600L, false));
        rules.add(this.createRule(3L, standard, "", sblc, iss, postage, "", "YEN", "", 0L, 40L, true));
        rules.add(this.createRule(4L, flat, "", sblc, osx, telex, "", "YEN", "<", 30000L, 45L, false));
        TestDataProvider tdp = new TestDataProvider(rules);
        DataProviderCompiler converter = new DataProviderCompiler();
        String drl = converter.compile((DataProvider)tdp, this.getTemplate());
        System.out.println(drl);
    }

    private InputStream getTemplate() {
        return DataDrivenTemplateExample.class.getResourceAsStream("FeeScheduleRules.drt");
    }

    private FeeScheduleRule createRule(long feeEventId, FeeScheduleType type, String entityBranch, ProductType productType, ActivityType activityType, FeeType feeType, String owningParty, String currency, String comparator, long compareAmount, long amount, boolean logEvent) {
        FeeScheduleRule rule = new FeeScheduleRule(feeEventId, activityType, productType, type, feeType, owningParty, entityBranch, comparator, compareAmount, amount, currency, logEvent);
        return rule;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestDataProvider
    implements DataProvider {
        private Iterator<FeeScheduleRule> iterator;

        TestDataProvider(List<FeeScheduleRule> rows) {
            this.iterator = rows.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public String[] next() {
            FeeScheduleRule nextRule = this.iterator.next();
            String[] row = new String[]{String.valueOf(nextRule.getFeeEventId()), nextRule.getType().getCode(), nextRule.getEntityBranch(), nextRule.getProductType().getCode(), nextRule.getActivityType().getName(), nextRule.getFeeType().getCode(), nextRule.getOwningParty(), nextRule.getCurrency(), nextRule.getComparator(), String.valueOf(nextRule.getCompareAmount()), String.valueOf(nextRule.getAmount()), String.valueOf(nextRule.isLogEvent())};
            return row;
        }
    }
}

