/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.decisiontable.InputType;
import org.drools.examples.decisiontable.Driver;
import org.drools.examples.decisiontable.Policy;
import org.drools.template.parser.TemplateDataListener;

public class PricingRuleTemplateExample {
    public static void main(String[] args) throws Exception {
        PricingRuleTemplateExample launcher = new PricingRuleTemplateExample();
        launcher.executeExample();
    }

    private int executeExample() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        ArrayList<TemplateDataListener> listeners = new ArrayList<TemplateDataListener>();
        TemplateDataListener l1 = new TemplateDataListener(10, 3, this.getBasePricingRulesStream());
        listeners.add(l1);
        TemplateDataListener l2 = new TemplateDataListener(30, 3, this.getPromotionalPricingRulesStream());
        listeners.add(l2);
        converter.compile(this.getSpreadsheetStream(), InputType.XLS, listeners);
        String baseRules = l1.renderDRL();
        String promotionalRules = l2.renderDRL();
        RuleBase rb = this.buildRuleBase(baseRules, promotionalRules);
        StatefulSession wm = rb.newStatefulSession();
        Driver driver = new Driver();
        Policy policy = new Policy();
        wm.insert((Object)driver);
        wm.insert((Object)policy);
        wm.fireAllRules();
        System.out.println("BASE PRICE IS: " + policy.getBasePrice());
        System.out.println("DISCOUNT IS: " + policy.getDiscountPercent());
        return policy.getBasePrice();
    }

    private RuleBase buildRuleBase(String ... drls) throws DroolsParserException, IOException, Exception {
        PackageBuilder builder = new PackageBuilder();
        for (String drl : drls) {
            builder.addPackageFromDrl((Reader)new StringReader(drl));
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        return ruleBase;
    }

    private InputStream getSpreadsheetStream() {
        return this.getClass().getResourceAsStream("ExamplePolicyPricing.xls");
    }

    private InputStream getBasePricingRulesStream() {
        return this.getClass().getResourceAsStream("BasePricing.drt");
    }

    private InputStream getPromotionalPricingRulesStream() {
        return this.getClass().getResourceAsStream("PromotionalPricing.drt");
    }
}

