/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.examples.templates.Cheese;
import org.drools.examples.templates.Person;

public class SimpleRuleTemplateExample {
    public static void main(String[] args) throws Exception {
        SimpleRuleTemplateExample launcher = new SimpleRuleTemplateExample();
        launcher.executeExample();
    }

    private void executeExample() throws Exception {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile(this.getSpreadsheetStream(), this.getRulesStream(), 2, 2);
        RuleBase rb = this.buildRuleBase(drl);
        StatefulSession wm = rb.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 42));
        wm.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        wm.fireAllRules();
        System.out.println(list);
    }

    private RuleBase buildRuleBase(String ... drls) throws DroolsParserException, IOException, Exception {
        PackageBuilder builder = new PackageBuilder();
        for (String drl : drls) {
            builder.addPackageFromDrl((Reader)new StringReader(drl));
        }
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        return ruleBase;
    }

    private InputStream getSpreadsheetStream() {
        return this.getClass().getResourceAsStream("ExampleCheese.xls");
    }

    private InputStream getRulesStream() {
        return this.getClass().getResourceAsStream("Cheese.drt");
    }
}

