/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.process.order;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Order {
    private String orderId;
    private String customerId;
    private int discountPercentage;
    private Date date;
    private List<OrderItem> orderItems = new ArrayList<OrderItem>();
    private List<String> errorList;
    private String trackingId;

    public Order() {
        this.date = new Date();
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public List<OrderItem> getOrderItems() {
        return this.orderItems;
    }

    public int getDiscountPercentage() {
        return this.discountPercentage;
    }

    public void setDiscountPercentage(int discountPercentage) {
        this.discountPercentage = discountPercentage;
    }

    public Date getDate() {
        return this.date;
    }

    public void addOrderItem(String itemId, int amount, double price) {
        this.orderItems.add(new OrderItem(itemId, amount, price));
    }

    public double getPrice() {
        double price = 0.0;
        for (OrderItem item : this.orderItems) {
            price += (double)item.getAmount() * item.getPrice();
        }
        return price;
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    public void addError(String error) {
        if (this.errorList == null) {
            this.errorList = new ArrayList<String>();
        }
        this.errorList.add(error);
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public String toString() {
        return "Order " + this.orderId;
    }

    public class OrderItem {
        private String itemId;
        private int amount;
        private double price;

        public OrderItem(String itemId, int amount, double price) {
            this.itemId = itemId;
            this.amount = amount;
            this.price = price;
        }

        public String getItemId() {
            return this.itemId;
        }

        public int getAmount() {
            return this.amount;
        }

        public double getPrice() {
            return this.price;
        }
    }
}

