/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.process.order;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.examples.process.order.Customer;
import org.drools.examples.process.order.DefaultCustomerService;
import org.drools.examples.process.order.DefaultItemCatalog;
import org.drools.examples.process.order.Item;
import org.drools.examples.process.order.Order;
import org.drools.examples.process.order.ShippingWorkItemHandler;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.process.instance.impl.demo.UIWorkItemHandler;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

public class OrderExample
extends JFrame {
    private static final long serialVersionUID = 4L;
    private KnowledgeBase kbase;
    private StatefulKnowledgeSession ksession;
    private KnowledgeRuntimeLogger logger;
    private int orderCounter;
    private JComboBox itemComboBox;
    private JTextField amountTextField;
    private JTextField customerIdTextField;
    private JTextField emailTextField;

    public static void main(String[] args) {
        new OrderExample().setVisible(true);
    }

    public OrderExample() {
        this.setSize(new Dimension(400, 220));
        this.setTitle("Order Example");
        this.setDefaultCloseOperation(2);
        this.createWorkingMemory();
        this.initializeComponent();
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        JLabel label = new JLabel("CustomerId");
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)label, c);
        this.customerIdTextField = new JTextField("A-12345");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.customerIdTextField, c);
        label = new JLabel("Item");
        c = new GridBagConstraints();
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)label, c);
        this.itemComboBox = new JComboBox<Object>(new Object[]{new ItemInfo("PC game", "I-9876", 50.0), new ItemInfo("Laptop", "I-5432", 500.0), new ItemInfo("Book", "Unknown", 5.0)});
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridy = 1;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.itemComboBox, c);
        label = new JLabel("Amount");
        c = new GridBagConstraints();
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)label, c);
        this.amountTextField = new JTextField("1");
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridy = 2;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.amountTextField, c);
        label = new JLabel("Email");
        c = new GridBagConstraints();
        c.gridy = 3;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)label, c);
        this.emailTextField = new JTextField();
        c = new GridBagConstraints();
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridy = 3;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.emailTextField, c);
        JButton createOrderButton = new JButton("Create");
        createOrderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OrderExample.this.createOrder();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 4;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)createOrderButton, c);
        final JCheckBox checkBox = new JCheckBox("Debugging output");
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (checkBox.isSelected()) {
                    OrderExample.this.addDebugRules();
                } else {
                    OrderExample.this.removeDebugRules();
                }
            }
        });
        c = new GridBagConstraints();
        c.gridwidth = 2;
        c.gridy = 5;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)checkBox, c);
    }

    private void createWorkingMemory() {
        try {
            this.kbase = OrderExample.createKnowledgeBase();
            this.ksession = this.kbase.newStatefulKnowledgeSession();
            this.logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)this.ksession, (String)"log/order");
            DefaultCustomerService customerService = new DefaultCustomerService();
            Customer c = new Customer("A-12345");
            Calendar birthday = Calendar.getInstance();
            birthday.set(1982, 1, 1);
            c.setBirthday(birthday.getTime());
            c.setFirstName("John");
            c.setLastName("Doe");
            customerService.addCustomer(c);
            this.ksession.setGlobal("customerService", (Object)customerService);
            DefaultItemCatalog itemCatalog = new DefaultItemCatalog();
            Item i = new Item("I-9876");
            i.setName("PC game");
            i.setMinimalAge(18);
            itemCatalog.addItem(i);
            i = new Item("I-5432");
            i.setName("Laptop");
            itemCatalog.addItem(i);
            this.ksession.setGlobal("itemCatalog", (Object)itemCatalog);
            this.ksession.getWorkItemManager().registerWorkItemHandler("Shipping", (WorkItemHandler)new ShippingWorkItemHandler(this.ksession));
            this.ksession.getWorkItemManager().registerWorkItemHandler("Email", new WorkItemHandler(){

                public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                    System.out.println("***********************************************************");
                    System.out.println("Sending email:");
                    System.out.println("From: " + workItem.getParameter("From"));
                    System.out.println("To: " + workItem.getParameter("To"));
                    System.out.println("Subject: " + workItem.getParameter("Subject"));
                    System.out.println("Text: ");
                    System.out.println(workItem.getParameter("Text"));
                    System.out.println("***********************************************************");
                    manager.completeWorkItem(workItem.getId(), null);
                }

                public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                }
            });
            UIWorkItemHandler handler = new UIWorkItemHandler();
            this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
            handler.setVisible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void addDebugRules() {
        try {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)"logging.drl", OrderExample.class), ResourceType.DRL);
            this.kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void removeDebugRules() {
        this.kbase.removeKnowledgePackage("org.drools.examples.process.order.logging");
    }

    public void dispose() {
        super.dispose();
        this.logger.close();
    }

    private void createOrder() {
        Order order = new Order();
        order.setOrderId("Order-" + ++this.orderCounter);
        order.setCustomerId(this.customerIdTextField.getText());
        ItemInfo itemInfo = (ItemInfo)this.itemComboBox.getSelectedItem();
        order.addOrderItem(itemInfo.getItemId(), new Integer(this.amountTextField.getText()), itemInfo.getPrice());
        this.ksession.insert((Object)order);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("order", order);
        parameters.put("email", this.emailTextField.getText());
        this.ksession.startProcess("org.drools.examples.process.ruleset.RuleSetExample", parameters);
        this.ksession.fireAllRules();
    }

    private static KnowledgeBase createKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"RuleSetExample.rf", OrderExample.class), ResourceType.DRF);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"workflow_rules.drl", OrderExample.class), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"validation.drl", OrderExample.class), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"assignment.dsl", OrderExample.class), ResourceType.DSL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"assignment.dslr", OrderExample.class), ResourceType.DSLR);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"discount.drl", OrderExample.class), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private class ItemInfo {
        private String name;
        private String itemId;
        private double price;

        public ItemInfo(String name, String itemId, double price) {
            this.name = name;
            this.itemId = itemId;
            this.price = price;
        }

        public String getName() {
            return this.name;
        }

        public String getItemId() {
            return this.itemId;
        }

        public double getPrice() {
            return this.price;
        }

        public String toString() {
            return this.name;
        }
    }
}

