/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.sudoku;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.drools.examples.sudoku.rules.DroolsSudokuGridModel;
import org.drools.examples.sudoku.swing.SudokuGridSamples;
import org.drools.examples.sudoku.swing.SudokuGridView;

public class Main
implements ActionListener {
    private JFrame mainFrame;
    private SudokuGridView sudokuGridView;
    private DroolsSudokuGridModel droolsSudokuGridModel;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenu samplesMenu = new JMenu("Samples");
    private JMenuItem openMenuItem = new JMenuItem("Open...");
    private JMenuItem exitMenuItem = new JMenuItem("Exit");
    private BorderLayout borderLayout = new BorderLayout();
    private FlowLayout flowLayout = new FlowLayout(2);
    private JPanel buttonPanel = new JPanel(this.flowLayout);
    private JButton solveButton = new JButton("Solve");
    private JFileChooser fileChooser;

    public static void main(String[] args) {
        Main main = new Main();
    }

    public Main() {
        this.mainFrame = new JFrame("Drools Sudoku Example");
        for (String sampleName : SudokuGridSamples.getInstance().getSampleNames()) {
            JMenuItem menuItem = new JMenuItem(sampleName);
            menuItem.addActionListener(this);
            this.samplesMenu.add(menuItem);
        }
        this.fileMenu.add(this.samplesMenu);
        this.openMenuItem.addActionListener(this);
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.mainFrame.setJMenuBar(this.menuBar);
        this.sudokuGridView = new SudokuGridView();
        this.droolsSudokuGridModel = new DroolsSudokuGridModel(SudokuGridSamples.getInstance().getSample("Simple"));
        this.mainFrame.setLayout(this.borderLayout);
        this.mainFrame.add("Center", this.sudokuGridView);
        this.buttonPanel.add(this.solveButton);
        this.solveButton.addActionListener(this);
        this.mainFrame.add("South", this.buttonPanel);
        this.mainFrame.setSize(400, 400);
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.setVisible(true);
        this.sudokuGridView.setModel(this.droolsSudokuGridModel);
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource().equals(this.solveButton)) {
            long startTime = System.currentTimeMillis();
            if (this.droolsSudokuGridModel.solve()) {
                this.solveButton.setText("Solved (" + (System.currentTimeMillis() - startTime) + " ms)");
                this.solveButton.setEnabled(false);
            } else {
                this.solveButton.setText("Unsolved (" + (System.currentTimeMillis() - startTime) + " ms)");
                this.solveButton.setEnabled(false);
            }
        } else if (ev.getSource().equals(this.openMenuItem)) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
            }
            try {
                if (this.fileChooser.showOpenDialog(this.mainFrame) == 0) {
                    System.out.println(this.fileChooser.getSelectedFile().getCanonicalPath());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (ev.getSource().equals(this.exitMenuItem)) {
            System.exit(0);
        } else if (ev.getSource() instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)ev.getSource();
            this.droolsSudokuGridModel = new DroolsSudokuGridModel(SudokuGridSamples.getInstance().getSample(menuItem.getText()));
            this.sudokuGridView.setModel(this.droolsSudokuGridModel);
            this.solveButton.setText("Solve");
            this.solveButton.setEnabled(true);
        }
    }
}

