/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.events;

import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventFeeder;
import org.drools.examples.broker.events.EventImpl;
import org.drools.examples.broker.events.EventReceiver;
import org.drools.examples.broker.events.EventSource;
import org.drools.time.TimerService;
import org.drools.time.impl.JDKTimerService;
import org.drools.time.impl.PseudoClockScheduler;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.Sequence;
import org.jmock.States;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.internal.StatePredicate;

public class EventFeederTest
extends TestCase {
    Mockery context = new Mockery();

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testFeedPseudoClock() {
        EventImpl event1 = new EventImpl(1000L, (Object)"one");
        EventImpl event2 = new EventImpl(1100L, (Object)"two");
        EventImpl event3 = new EventImpl(1120L, (Object)"three");
        EventImpl event4 = new EventImpl(1300L, (Object)"four");
        EventImpl event5 = new EventImpl(1550L, (Object)"five");
        EventImpl event6 = new EventImpl(1700L, (Object)"six");
        final Sequence seq = this.context.sequence("call sequence");
        States ts = this.context.states("timestamp").startsAs(String.valueOf(event1.getTimestamp()));
        final EventSource source = (EventSource)this.context.mock(EventSource.class);
        EventReceiver receiver = (EventReceiver)this.context.mock(EventReceiver.class);
        PseudoClockScheduler clock = new PseudoClockScheduler();
        EventFeeder feeder = new EventFeeder((TimerService)clock, source, receiver);
        this.context.checking((ExpectationBuilder)new Expectations((Event)event1, receiver, ts, (Event)event2, (Event)event3, (Event)event4, (Event)event5, (Event)event6){
            final /* synthetic */ Event val$event1;
            final /* synthetic */ EventReceiver val$receiver;
            final /* synthetic */ States val$ts;
            final /* synthetic */ Event val$event2;
            final /* synthetic */ Event val$event3;
            final /* synthetic */ Event val$event4;
            final /* synthetic */ Event val$event5;
            final /* synthetic */ Event val$event6;
            {
                this.val$event1 = event;
                this.val$receiver = eventReceiver;
                this.val$ts = states;
                this.val$event2 = event2;
                this.val$event3 = event3;
                this.val$event4 = event4;
                this.val$event5 = event5;
                this.val$event6 = event6;
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)this.val$event1));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event1);
                this.inSequence(seq);
                this.when((StatePredicate)this.val$ts.is(String.valueOf(this.val$event1.getTimestamp())));
                this.then(this.val$ts.is(String.valueOf(this.val$event2.getTimestamp())));
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)this.val$event2));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event2);
                this.inSequence(seq);
                this.when((StatePredicate)this.val$ts.is(String.valueOf(this.val$event2.getTimestamp())));
                this.then(this.val$ts.is(String.valueOf(this.val$event3.getTimestamp())));
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)this.val$event3));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event3);
                this.inSequence(seq);
                this.when((StatePredicate)this.val$ts.is(String.valueOf(this.val$event3.getTimestamp())));
                this.then(this.val$ts.is(String.valueOf(this.val$event4.getTimestamp())));
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)this.val$event4));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event4);
                this.inSequence(seq);
                this.when((StatePredicate)this.val$ts.is(String.valueOf(this.val$event4.getTimestamp())));
                this.then(this.val$ts.is(String.valueOf(this.val$event5.getTimestamp())));
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)this.val$event5));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event5);
                this.inSequence(seq);
                this.when((StatePredicate)this.val$ts.is(String.valueOf(this.val$event5.getTimestamp())));
                this.then(this.val$ts.is(String.valueOf(this.val$event6.getTimestamp())));
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)this.val$event6));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event6);
                this.inSequence(seq);
                this.when((StatePredicate)this.val$ts.is(String.valueOf(this.val$event6.getTimestamp())));
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(1.returnValue((Object)false));
            }
        });
        feeder.feed();
        clock.advanceTime(event1.getTimestamp() - clock.getCurrentTime(), TimeUnit.MILLISECONDS);
        clock.advanceTime(event2.getTimestamp() - clock.getCurrentTime(), TimeUnit.MILLISECONDS);
        clock.advanceTime(event3.getTimestamp() - clock.getCurrentTime(), TimeUnit.MILLISECONDS);
        clock.advanceTime(event4.getTimestamp() - clock.getCurrentTime(), TimeUnit.MILLISECONDS);
        clock.advanceTime(event5.getTimestamp() - clock.getCurrentTime(), TimeUnit.MILLISECONDS);
        clock.advanceTime(event6.getTimestamp() - clock.getCurrentTime(), TimeUnit.MILLISECONDS);
        this.context.assertIsSatisfied();
    }

    public void testFeedRealtimeClock() {
        long startTime = System.currentTimeMillis() + 10000L;
        EventImpl event1 = new EventImpl(startTime + 1000L, (Object)"one");
        EventImpl event2 = new EventImpl(startTime + 1100L, (Object)"two");
        EventImpl event3 = new EventImpl(startTime + 1120L, (Object)"three");
        EventImpl event4 = new EventImpl(startTime + 1300L, (Object)"four");
        EventImpl event5 = new EventImpl(startTime + 1550L, (Object)"five");
        EventImpl event6 = new EventImpl(startTime + 1700L, (Object)"six");
        final Sequence seq = this.context.sequence("call sequence");
        final EventSource source = (EventSource)this.context.mock(EventSource.class);
        EventReceiver receiver = (EventReceiver)this.context.mock(EventReceiver.class);
        JDKTimerService clock = new JDKTimerService(1);
        EventFeeder feeder = new EventFeeder((TimerService)clock, source, receiver);
        this.context.checking((ExpectationBuilder)new Expectations((Event)event1, receiver, (Event)event2, (Event)event3, (Event)event4, (Event)event5, (Event)event6){
            final /* synthetic */ Event val$event1;
            final /* synthetic */ EventReceiver val$receiver;
            final /* synthetic */ Event val$event2;
            final /* synthetic */ Event val$event3;
            final /* synthetic */ Event val$event4;
            final /* synthetic */ Event val$event5;
            final /* synthetic */ Event val$event6;
            {
                this.val$event1 = event;
                this.val$receiver = eventReceiver;
                this.val$event2 = event2;
                this.val$event3 = event3;
                this.val$event4 = event4;
                this.val$event5 = event5;
                this.val$event6 = event6;
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)this.val$event1));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event1);
                this.inSequence(seq);
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)this.val$event2));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event2);
                this.inSequence(seq);
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)this.val$event3));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event3);
                this.inSequence(seq);
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)this.val$event4));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event4);
                this.inSequence(seq);
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)this.val$event5));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event5);
                this.inSequence(seq);
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)true));
                ((EventSource)this.oneOf(source)).getNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)this.val$event6));
                ((EventReceiver)this.oneOf(this.val$receiver)).receive(this.val$event6);
                this.inSequence(seq);
                ((EventSource)this.oneOf(source)).hasNext();
                this.inSequence(seq);
                this.will(2.returnValue((Object)false));
            }
        });
        feeder.feed();
        try {
            Thread.currentThread();
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.context.assertIsSatisfied();
    }
}

