/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.pacman;

import org.drools.examples.pacman.Character;
import org.drools.examples.pacman.DirectionEnum;

public class Direction {
    public static final int NONE = 0;
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int UP = 1;
    public static final int DOWN = -1;
    private Character character;
    private int horizontal;
    private int vertical;

    public Direction(Character character, int horizontal, int vertical) {
        this.character = character;
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    public Character getCharacter() {
        return this.character;
    }

    public int getHorizontal() {
        return this.horizontal;
    }

    public int getVertical() {
        return this.vertical;
    }

    public static Direction newDirection(Character character, DirectionEnum directionEnum) {
        switch (directionEnum) {
            case LEFT: {
                return new Direction(character, -1, 0);
            }
            case RIGHT: {
                return new Direction(character, 1, 0);
            }
            case UP: {
                return new Direction(character, 0, 1);
            }
            case DOWN: {
                return new Direction(character, 0, -1);
            }
        }
        throw new IllegalArgumentException("Direction must be a valid DirectionEnum");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.character == null ? 0 : this.character.hashCode());
        result = 31 * result + this.horizontal;
        result = 31 * result + this.vertical;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Direction other = (Direction)obj;
        if (this.character == null ? other.character != null : !this.character.equals(other.character)) {
            return false;
        }
        if (this.horizontal != other.horizontal) {
            return false;
        }
        return this.vertical == other.vertical;
    }

    public String toString() {
        if (this.horizontal != 0) {
            return "Direction " + this.character + " " + (this.horizontal == -1 ? "LEFT" : "RIGHT");
        }
        return "Direction " + this.character + " " + (this.vertical == 1 ? "UP" : "DOWN");
    }
}

