/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.pong;

public class PongConfiguration {
    private int tableWidth;
    private int tableHeight;
    private int padding;
    private int sideLineWidth;
    private int netWidth;
    private int netDash;
    private int netGap;
    private int ballWidth;
    private int ballStartingSpeed;
    private int batWidth;
    private int batHeight;
    private int batSpeed;

    public PongConfiguration() {
        this.setTableWidth(700);
        this.setTableHeight(500);
        this.setSideLineWidth(10);
        this.setBallWidth(20);
        this.setBallStartingSpeed(60);
        this.setBatWidth(5);
        this.setBatHeight(80);
        this.setBatSpeed(15);
        this.setPadding(10);
        this.setNet(2, 20, 10);
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public void setTableWidth(int tableWidth) {
        this.validTableDimension(tableWidth);
        this.tableWidth = tableWidth;
    }

    public int getTableHeight() {
        return this.tableHeight;
    }

    public void setTableHeight(int tableHeight) {
        this.validTableDimension(tableHeight);
        this.tableHeight = tableHeight;
    }

    private void validTableDimension(int dimension) {
        if (dimension % 20 != 0) {
            throw new IllegalArgumentException("Table dimensions must be divisiable by 20");
        }
    }

    public int getSideLineWidth() {
        return this.sideLineWidth;
    }

    public void setSideLineWidth(int sideLineWidth) {
        this.sideLineWidth = sideLineWidth;
    }

    public int getBallWidth() {
        return this.ballWidth;
    }

    public void setBallWidth(int ballWidth) {
        this.ballWidth = ballWidth;
    }

    public int getBallStartingSpeed() {
        return this.ballStartingSpeed;
    }

    public void setBallStartingSpeed(int ballStartingSpeed) {
        this.ballStartingSpeed = ballStartingSpeed;
    }

    public int getBatWidth() {
        return this.batWidth;
    }

    public void setBatWidth(int batWidth) {
        this.batWidth = batWidth;
    }

    public int getBatHeight() {
        return this.batHeight;
    }

    public void setBatHeight(int batHeight) {
        this.batHeight = batHeight;
    }

    public int getBatSpeed() {
        return this.batSpeed;
    }

    public void setBatSpeed(int batSpeed) {
        this.batSpeed = batSpeed;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setNet(int width, int dash, int gap) {
        if (width % 2 != 0) {
            throw new IllegalArgumentException("Fence Width must be divisiable by 2");
        }
        this.netWidth = width;
        this.netDash = dash;
        this.netGap = gap;
    }

    public int getNetWidth() {
        return this.netWidth;
    }

    public int getNetDash() {
        return this.netDash;
    }

    public int getNetGap() {
        return this.netGap;
    }
}

