/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.wumpus;

import java.util.Random;
import org.drools.games.wumpus.WumpusWorldConfiguration;
import org.drools.games.wumpus.view.GameView;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.runtime.Channel;
import org.kie.runtime.StatefulKnowledgeSession;

public class WumpusWorldMain {
    public static void main(String[] args) {
        new WumpusWorldMain().init(true);
    }

    public void init(boolean exitOnClose) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.batch().add(ResourceFactory.newClassPathResource((String)"init.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"commands.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"shoot.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"ui.drl", GameView.class), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"paintCave.drl", GameView.class), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"paintSensor.drl", GameView.class), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"score.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"sensorArray.drl", this.getClass()), ResourceType.DRL).build();
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase serverKBase = KnowledgeBaseFactory.newKnowledgeBase();
        serverKBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.batch().add(ResourceFactory.newClassPathResource((String)"client.drl", this.getClass()), ResourceType.DRL).build();
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase clientKBase = KnowledgeBaseFactory.newKnowledgeBase();
        clientKBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        final StatefulKnowledgeSession serverKsession = serverKBase.newStatefulKnowledgeSession();
        final StatefulKnowledgeSession clientKsession = clientKBase.newStatefulKnowledgeSession();
        serverKsession.getChannels().put("sensors", new Channel(){

            public void send(Object object) {
                clientKsession.insert(object);
                clientKsession.fireAllRules();
            }
        });
        clientKsession.getChannels().put("commands", new Channel(){

            public void send(Object object) {
                serverKsession.insert(object);
                serverKsession.fireAllRules();
            }
        });
        WumpusWorldConfiguration wumpusWorldConfiguration = new WumpusWorldConfiguration();
        wumpusWorldConfiguration.setExitOnClose(exitOnClose);
        serverKsession.setGlobal("wumpusWorldConfiguration", (Object)wumpusWorldConfiguration);
        serverKsession.setGlobal("randomInteger", (Object)new Random());
        serverKsession.fireAllRules();
        clientKsession.fireAllRules();
    }
}

