/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.adventures;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.games.adventures.Action;
import org.drools.games.adventures.Counter;
import org.drools.games.adventures.Request;
import org.drools.games.adventures.UserSession;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;

public class GameEngine {
    StatefulKnowledgeSession ksession;
    ClassLoader classLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGame() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.batch().add(ResourceFactory.newClassPathResource((String)"Model.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"Queries.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"General.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"Response.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"Events.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"UiView.drl", this.getClass()), ResourceType.DRL).add(ResourceFactory.newClassPathResource((String)"Commands.drl", this.getClass()), ResourceType.DRL).build();
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors().toString());
            System.exit(1);
        }
        KieBaseConfiguration kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbaseConf.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbaseConf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Counter c = new Counter();
        this.ksession = kbase.newStatefulKnowledgeSession();
        this.ksession.setGlobal("counter", (Object)c);
        this.classLoader = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRootClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Map map;
            Thread.currentThread().setContextClassLoader(this.classLoader);
            HashMap<String, Counter> vars = new HashMap<String, Counter>();
            vars.put("c", c);
            try {
                map = (Map)MVEL.executeExpression((Object)MVEL.compileExpression((String)new String(IOUtils.toByteArray((InputStream)this.getClass().getResource("data.mvel").openStream()))), vars);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (Object o : ((Map)map.get("rooms")).values()) {
                this.ksession.insert(o);
            }
            for (Object o : ((Map)map.get("doors")).values()) {
                this.ksession.insert(o);
            }
            for (Object o : ((Map)map.get("characters")).values()) {
                this.ksession.insert(o);
            }
            for (Object o : ((Map)map.get("items")).values()) {
                this.ksession.insert(o);
            }
            for (Object o : ((Map)map.get("locations")).values()) {
                this.ksession.insert(o);
            }
            MapVariableResolverFactory f = new MapVariableResolverFactory(map);
            String baseStr = "import  org.drools.games.adventures.*;  import org.drools.games.adventures.commands.*;\n";
            FactHandle fh = this.ksession.insert(MVEL.eval((String)(baseStr + "new EnterEvent( characters['hero'], rooms['first floor hallway'] )"), (VariableResolverFactory)f));
            this.ksession.fireAllRules();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveMessage(UserSession session, List cmd) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        String baseStr = "import  org.drools.games.adventures.*;  import org.drools.games.adventures.commands.*;\n";
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            HashMap<String, List> vars = new HashMap<String, List>();
            vars.put("args", cmd);
            MapVariableResolverFactory f = new MapVariableResolverFactory(vars);
            Action c = (Action)((Object)cmd.get(0));
            switch (c) {
                case MOVE: {
                    this.ksession.insert((Object)new Request(session, MVEL.eval((String)(baseStr + "new MoveCommand(args[1], args[2])"), (VariableResolverFactory)f)));
                    this.ksession.fireAllRules();
                    return;
                }
                case PICKUP: {
                    this.ksession.insert((Object)new Request(session, MVEL.eval((String)(baseStr + "new PickupCommand(args[1], args[2])"), (VariableResolverFactory)f)));
                    this.ksession.fireAllRules();
                    return;
                }
                case DROP: {
                    this.ksession.insert((Object)new Request(session, MVEL.eval((String)(baseStr + "new DropCommand(args[1], args[2])"), (VariableResolverFactory)f)));
                    this.ksession.fireAllRules();
                    return;
                }
                case GIVE: {
                    this.ksession.insert((Object)new Request(session, MVEL.eval((String)(baseStr + "new GiveCommand(args[1], args[2], args[3])"), (VariableResolverFactory)f)));
                    this.ksession.fireAllRules();
                    return;
                }
                case LOOK: {
                    this.ksession.insert((Object)new Request(session, MVEL.eval((String)(baseStr + "new LookCommand(args[1])"), (VariableResolverFactory)f)));
                    this.ksession.fireAllRules();
                    return;
                }
                case SELECT_CHARACTER: {
                    this.ksession.insert((Object)new Request(session, MVEL.eval((String)(baseStr + "new SetSessionCharacterCommand(args[1], args[2])"), (VariableResolverFactory)f)));
                    this.ksession.fireAllRules();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            session.getChannels().get("output").send((Object)("Unable to Execute Command: " + cmd));
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }
}

