/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.pong;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.drools.games.pong.PongConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.SessionEntryPoint;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class PongUI {
    private PongConfiguration pconf;
    private JFrame frame;
    private TablePanel tablePanel;
    private boolean ready;
    StatefulKnowledgeSession ksession;

    public PongUI() {
        this(new PongConfiguration());
        this.init(null);
    }

    public PongUI(PongConfiguration pconf) {
        this.pconf = pconf;
    }

    public StatefulKnowledgeSession getKsession() {
        return this.ksession;
    }

    public void setKsession(StatefulKnowledgeSession ksession) {
        this.ksession = ksession;
    }

    public PongConfiguration getPconf() {
        return this.pconf;
    }

    public void setPconf(PongConfiguration pconf) {
        this.pconf = pconf;
    }

    public TablePanel getTablePanel() {
        return this.tablePanel;
    }

    public void setTablePanel(TablePanel tablePanel) {
        this.tablePanel = tablePanel;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public void init(StatefulKnowledgeSession ksession) {
        this.ksession = ksession;
        this.frame = new JFrame();
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(this.pconf.isExitOnClose() ? 3 : 2);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.tablePanel = new TablePanel(this);
        this.tablePanel.setPreferredSize(new Dimension(this.pconf.getTableWidth(), this.pconf.getTableHeight()));
        this.tablePanel.setBackground(Color.BLACK);
        this.frame.getContentPane().add(this.tablePanel);
        this.tablePanel.setLayout(new BorderLayout());
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        PongKeyListener klistener = new PongKeyListener(ksession.getEntryPoint("KeyPressedStream"), ksession.getEntryPoint("KeyReleasedStream"));
        this.frame.addKeyListener(klistener);
        this.updateTable();
    }

    public synchronized void updateTable() {
        this.tablePanel.repaint();
        this.tablePanel.revalidate();
    }

    public static class TablePanel
    extends JPanel {
        private PongUI pongUI;
        private BufferedImage bi;
        private Graphics tableG;

        public TablePanel(PongUI pongUI) {
            this.setOpaque(true);
            this.pongUI = pongUI;
        }

        public Graphics getTableG() {
            if (this.bi == null) {
                PongConfiguration pconf = this.pongUI.getPconf();
                this.bi = new BufferedImage(pconf.getTableWidth() + 200, pconf.getTableHeight(), 1);
                this.tableG = this.bi.createGraphics();
                this.tableG.setColor(Color.BLACK);
                this.tableG.fillRect(0, 0, pconf.getTableWidth() + 200, pconf.getTableHeight());
                StatefulKnowledgeSession ksession = this.pongUI.getKsession();
                FactHandle fh = ksession.getFactHandle((Object)this.pongUI);
                this.pongUI.setReady(true);
                ksession.update(fh, (Object)this.pongUI);
            }
            return this.tableG;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.pongUI != null) {
                this.getTableG();
                PongConfiguration pconf = this.pongUI.getPconf();
                g.drawImage(this.bi, 0, 0, pconf.getTableWidth(), pconf.getTableHeight(), 0, 0, pconf.getTableWidth(), pconf.getTableHeight(), null);
            }
        }
    }

    public static class PongKeyListener
    implements KeyListener {
        SessionEntryPoint keyPressedEntryPoint;
        SessionEntryPoint keyReleasedEntryPoint;

        public PongKeyListener(SessionEntryPoint keyPressedEntryPoint, SessionEntryPoint keyReleasedEntryPoint) {
            this.keyPressedEntryPoint = keyPressedEntryPoint;
            this.keyReleasedEntryPoint = keyReleasedEntryPoint;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyPressedEntryPoint.insert((Object)e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyReleasedEntryPoint.insert((Object)e);
        }
    }
}

