/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.templates;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.examples.templates.Cheese;
import org.drools.examples.templates.Person;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class SimpleRuleTemplateExample {
    public static void main(String[] args) {
        SimpleRuleTemplateExample launcher = new SimpleRuleTemplateExample();
        launcher.executeExample();
    }

    private void executeExample() {
        KnowledgeBase kbase = this.buildKBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Cheese("stilton", 42));
        ksession.insert((Object)new Person("michael", "stilton", 42));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        System.out.println(list);
        ksession.dispose();
    }

    private KnowledgeBase buildKBase() {
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = null;
        try {
            drl = converter.compile(this.getSpreadsheetStream(), this.getRulesStream(), 2, 2);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read spreadsheet or rules stream.", e);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println("Error compiling resources:");
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                System.out.println("\t" + ((KnowledgeBuilderError)errors.next()).getMessage());
            }
            throw new IllegalStateException("Error compiling resources");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private InputStream getSpreadsheetStream() throws IOException {
        return ResourceFactory.newClassPathResource((String)"org/drools/examples/templates/ExampleCheese.xls").getInputStream();
    }

    private InputStream getRulesStream() throws IOException {
        return ResourceFactory.newClassPathResource((String)"org/drools/examples/templates/Cheese.drt").getInputStream();
    }
}

