/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.pong;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.drools.games.invaders.FPSTimer;
import org.drools.games.pong.PongConfiguration;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class PongMain {
    public static void main(String[] args) {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        new PongMain().init(kc, true);
    }

    public void init(KieContainer kc, boolean exitOnClose) {
        KieSession ksession = kc.newKieSession("PongKS");
        PongConfiguration pconf = new PongConfiguration();
        pconf.setExitOnClose(exitOnClose);
        ksession.setGlobal("pconf", (Object)pconf);
        ksession.setGlobal("fpsTimer", (Object)new FPSTimer(10L));
        this.runKSession(ksession);
    }

    public void runKSession(final KieSession ksession) {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ksession.fireUntilHalt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

