/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.fire;

import java.util.HashMap;
import java.util.Scanner;
import org.drools.examples.fire.Fire;
import org.drools.examples.fire.Room;
import org.drools.examples.fire.Sprinkler;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class FireExample {
    public static void main(String[] args) {
        KieContainer kc = KieServices.Factory.get().getKieClasspathContainer();
        KieSession ksession = kc.newKieSession("FireKS");
        String[] names = new String[]{"kitchen", "bedroom", "office", "livingroom"};
        HashMap<String, Room> name2room = new HashMap<String, Room>();
        for (String name : names) {
            Room room = new Room(name);
            name2room.put(name, room);
            ksession.insert((Object)room);
            Sprinkler sprinkler = new Sprinkler(room);
            ksession.insert((Object)sprinkler);
        }
        ksession.fireAllRules();
        FireExample.pause();
        Fire kitchenFire = new Fire((Room)name2room.get("kitchen"));
        Fire officeFire = new Fire((Room)name2room.get("office"));
        FactHandle kitchenFireHandle = ksession.insert((Object)kitchenFire);
        FactHandle officeFireHandle = ksession.insert((Object)officeFire);
        ksession.fireAllRules();
        FireExample.pause();
        ksession.delete(kitchenFireHandle);
        ksession.delete(officeFireHandle);
        ksession.fireAllRules();
        ksession.dispose();
    }

    public static void pause() {
        System.out.println("Pressure enter to contnue");
        Scanner keyboard = new Scanner(System.in);
        keyboard.nextLine();
    }
}

