/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.performance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class PerformanceExample {
    public static void main(String[] args) throws Exception {
        FactType ft;
        StatelessKieSession kSession;
        long numberOfRulesToBuild = 10L;
        boolean useAccumulate = true;
        String dialect = "mvel";
        boolean usekjars = false;
        boolean collectionBasedRules = true;
        System.out.println("********* Numbers of rules: 10 kjars: " + usekjars + " accumulate: " + useAccumulate + " dialect: " + dialect + " *********");
        String rules = PerformanceExample.getRules(10L, useAccumulate, dialect, collectionBasedRules);
        long startTime = System.currentTimeMillis();
        if (usekjars) {
            KieContainer kContainer = PerformanceExample.loadContainerFromString(rules);
            kSession = kContainer.newStatelessKieSession();
            ft = kContainer.getKieBase().getFactType("org.drools.examples.performance", "TransactionC");
        } else {
            KieBase kbase = PerformanceExample.loadKnowledgeBaseFromString(rules);
            kSession = kbase.newStatelessKieSession();
            ft = kbase.getFactType("org.drools.examples.performance", "TransactionC");
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Total time to build and load knowledgebase: " + (endTime - startTime) + " ms");
        ArrayList output = new ArrayList();
        kSession.setGlobal("mo", output);
        Object o = ft.newInstance();
        Gson gConverter = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss").create();
        Object fo = gConverter.fromJson(PerformanceExample.getFact(), o.getClass());
        kSession.execute(fo);
        startTime = System.currentTimeMillis();
        kSession.execute(fo);
        endTime = System.currentTimeMillis();
        System.out.println("Execution time: " + (endTime - startTime) + " ms");
        String rulesOutput = gConverter.toJson(output);
        System.out.println(rulesOutput);
    }

    private static KieContainer loadContainerFromString(String rules) {
        long startTime = System.currentTimeMillis();
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/examples/pertest.drl", rules);
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time to build rules : " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        endTime = System.currentTimeMillis();
        System.out.println("Time to load container: " + (endTime - startTime) + " ms");
        return kContainer;
    }

    protected static KieBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        long startTime = System.currentTimeMillis();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Build Errors:\n" + kbuilder.getErrors());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time to build rules: " + (endTime - startTime) + " ms");
        startTime = System.currentTimeMillis();
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        endTime = System.currentTimeMillis();
        System.out.println("Time to create knowledgebase: " + (endTime - startTime) + " ms");
        return kbase;
    }

    private static String getFact() {
        return "{\n\"TransactionNumber\": \"88882\",\n\"TrackingID\": \"T001\",\n\"CurrencyCode\": \"USD\",\n\"TransactionNetTotal\" : 100.0,\n\"StoreCode\": \"D001\",\n\"CardNumber\": \"3614838386\",\n\"TransactionDetails\": [\n{\n\"Quantity\": 25,\n\"ItemNumber\": \"SKU1_0\",\n\"BrandID\": \"Nike\",\n\"SKU\": \"SKU1\",\n\"ProductCategoryCode\" : \"Clothing\"\n}]\n}";
    }

    private static String getRules(long numberofRules, boolean useAccumulate, String dialect, boolean collectionBasedRules) {
        long startTime = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder("package org.drools.examples.performance;\n");
        sb.append(PerformanceExample.getImportStatements());
        sb.append("global ArrayList<Outcome> mo;");
        sb.append(PerformanceExample.getDeclareStatements());
        for (long l = 0L; l < numberofRules; ++l) {
            sb.append(PerformanceExample.createRule(l, useAccumulate, dialect, collectionBasedRules));
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Time to generate: " + (endTime - startTime) + " ms");
        return sb.toString();
    }

    private static String createRule(long number, boolean useAccumulate, String dialect, boolean collectionBasedRules) {
        if (collectionBasedRules) {
            return PerformanceExample.createCollectionRule(number, useAccumulate, dialect);
        }
        return PerformanceExample.createRule(number, useAccumulate, dialect);
    }

    private static String createRule(long number, boolean useAccumulate, String dialect) {
        String s = "rule \"rule" + number + "\" \n";
        if (!dialect.isEmpty()) {
            s = s + "dialect \"" + dialect + "\"\n";
        }
        s = s + "when   t : TransactionC(CurrencyCode == \"USD" + number + "\") \n";
        if (useAccumulate) {
            s = s + "accumulate($item:TransactionDetailsC() from t.TransactionDetails, $totQty: collectList($item.getQuantity()))\n";
        }
        s = s + "then \nmo.add(new Outcome(\"rule" + number + "\", t.getTransactionNumber()));\nend \n";
        return s;
    }

    private static String createCollectionRule(long number, boolean useAccumulate, String dialect) {
        long NumOfSKU = 10L;
        String sku = "";
        String prefix = "";
        for (long l = 0L; l < NumOfSKU; ++l) {
            sku = sku + prefix + "\"SKU" + number + "_" + l + "\"";
            prefix = ",";
        }
        String s = "rule \"rule" + number + "\" \n";
        if (!dialect.isEmpty()) {
            s = s + "dialect \"" + dialect + "\"\n";
        }
        s = s + "when   t : TransactionC() \nd: TransactionDetailsC(ItemNumber in (" + sku + ")) from t.TransactionDetails \n";
        if (useAccumulate) {
            s = s + "accumulate($item:TransactionDetailsC(ItemNumber in (" + sku + ")) from t.TransactionDetails, $totQty: collectList($item.getQuantity()))\n";
        }
        s = s + "then \nmo.add(new Outcome(\"rule" + number + "\", d.getBrandID()));\nend \n";
        return s;
    }

    private static String createRules2(String dialect) {
        return "rule \"r1\"\ndialect \"" + dialect + "\"\nwhen   t : TransactionC(CurrencyCode == \"USD\") \nthen \nmo.add(new Outcome(\"r1\" , t.getTransactionNumber()));\nend \nrule \"r2\"\ndialect \"" + dialect + "\"\nwhen   t : TransactionC(CurrencyCode == \"USD\") \nthen \nmo.add(new Outcome(\"r2\" , t.getTransactionNumber()));\nend \nrule \"r3\"\ndialect \"" + dialect + "\"\nwhen   t : TransactionC(CurrencyCode == \"CAD\") \nthen \nmo.add(new Outcome(\"r3\", t.getTransactionNumber()));\nend \nrule \"r4\"\ndialect \"" + dialect + "\"\nwhen   t : TransactionC(CurrencyCode == \"USD\") \nthen \nmo.add(new Outcome(\"r4\", t.getTransactionNumber()));\nend \n";
    }

    private static String getDeclareStatements() {
        return "declare TransactionC \nCardNumber : String \nStoreCode : String \nTrackingID : String \nCurrencyCode : String \nTransactionNetTotal : Double \nTransactionNumber : String \nTransactionDetails : TransactionDetailsC[] \nend \ndeclare TransactionDetailsC \nItemNumber : String \nBrandID : String \nSKU : String \nProductCategoryCode : String \nQuantity : Double \nend\ndeclare Outcome \nRuleId : String \nOutcomeValue : String \nend \n";
    }

    private static String getImportStatements() {
        return "import java.util.ArrayList \nimport java.util.List \n";
    }
}

