/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.rules;

import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.base.ClassTypeResolver;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.ClassToGenericClassConverter;
import org.drools.ide.common.server.util.ClassMethodInspector;
import org.drools.ide.common.server.util.DataEnumLoader;
import org.drools.ide.common.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.lang.dsl.AbstractDSLMappingEntry;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.rule.MapBackedClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionCompletionLoader
implements ClassToGenericClassConverter {
    private final SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();
    private final DrlParser parser = new DrlParser();
    private final MapBackedClassLoader loader;
    protected List<String> errors = new ArrayList<String>();
    final ClassTypeResolver resolver;
    private List<ExternalImportDescrProvider> externalImportDescrProviders = new ArrayList<ExternalImportDescrProvider>();

    public SuggestionCompletionLoader() {
        this(null);
    }

    public SuggestionCompletionLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.loader = new MapBackedClassLoader(classLoader);
        this.resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)this.loader);
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List<JarInputStream> jars, List<DSLTokenizedMappingFile> dsls) {
        return this.getSuggestionEngine(header, jars, dsls, Collections.EMPTY_LIST);
    }

    public SuggestionCompletionEngine getSuggestionEngine(String header, List<JarInputStream> jars, List<DSLTokenizedMappingFile> dsls, List<String> dataEnums) {
        this.builder.newCompletionEngine();
        if (!header.trim().equals("")) {
            this.processPackageHeader(header, jars);
        }
        this.populateDSLSentences(dsls);
        SuggestionCompletionEngine sce = this.builder.getInstance();
        this.populateDateEnums(dataEnums, sce);
        return sce;
    }

    private void populateDateEnums(List<String> dataEnums, SuggestionCompletionEngine sce) {
        for (String enumFile : dataEnums) {
            DataEnumLoader enumLoader = new DataEnumLoader(enumFile);
            if (enumLoader.hasErrors()) {
                this.errors.addAll(enumLoader.getErrors());
                continue;
            }
            sce.putAllDataEnumLists(enumLoader.getData());
        }
    }

    private void processPackageHeader(String header, List jars) {
        PackageDescr pkgDescr;
        try {
            pkgDescr = this.parser.parse(header);
        }
        catch (DroolsParserException e1) {
            throw new IllegalStateException("Serious error, unable to validate package.");
        }
        if (this.parser.hasErrors()) {
            Iterator iter = this.parser.getErrors().iterator();
            while (iter.hasNext()) {
                this.errors.add(((DroolsError)iter.next()).getMessage());
            }
        }
        if (pkgDescr != null) {
            this.populateModelInfo(pkgDescr, jars);
            this.populateGlobalInfo(pkgDescr, jars);
        }
    }

    private void populateDSLSentences(List<DSLTokenizedMappingFile> dsls) {
        for (DSLTokenizedMappingFile file : dsls) {
            DSLMapping mapping = file.getMapping();
            for (AbstractDSLMappingEntry entry : mapping.getEntries()) {
                if (entry.getSection() == DSLMappingEntry.CONDITION) {
                    this.builder.addDSLConditionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() == DSLMappingEntry.CONSEQUENCE) {
                    this.builder.addDSLActionSentence(entry.getMappingKey());
                    continue;
                }
                if (entry.getSection() == DSLMappingEntry.KEYWORD) {
                    this.builder.addDSLMapping((DSLMappingEntry)entry);
                    continue;
                }
                if (entry.getSection() != DSLMappingEntry.ANY) continue;
            }
        }
    }

    private void populateGlobalInfo(PackageDescr pkgDescr, List jars) {
        for (GlobalDescr global : pkgDescr.getGlobals()) {
            try {
                String shortTypeName = this.getShortNameOfClass(global.getType());
                Class clazz = this.loadClass(global.getType(), jars);
                if (!this.builder.hasFieldsForType(shortTypeName)) {
                    this.loadClassFields(clazz, shortTypeName);
                    this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
                }
                if (clazz != null && Collection.class.isAssignableFrom(clazz)) {
                    this.builder.addGlobalCollection(global.getIdentifier());
                }
                this.builder.addGlobalType(global.getIdentifier(), shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting class for global: " + global.getType() + " error message: " + e.getMessage());
            }
        }
    }

    private void populateModelInfo(PackageDescr pkgDescr, List jars) {
        ArrayList<ImportDescr> imports = new ArrayList<ImportDescr>(pkgDescr.getImports());
        if (this.externalImportDescrProviders != null) {
            for (ExternalImportDescrProvider externalImportDescrProvider : this.externalImportDescrProviders) {
                imports.addAll(externalImportDescrProvider.getImportDescrs());
            }
        }
        for (ImportDescr imp : imports) {
            String className = imp.getTarget();
            if (className.endsWith("*")) {
                this.errors.add("Unable to introspect model for wild card imports (" + className + "). Please explicitly import each fact type you require.");
                continue;
            }
            this.resolver.addImport(className);
            Class clazz = this.loadClass(className, jars);
            if (clazz == null) continue;
            try {
                String shortTypeName = this.getShortNameOfClass(clazz.getName());
                this.builder.addFactType(shortTypeName, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS);
                this.loadClassFields(clazz, shortTypeName);
            }
            catch (IOException e) {
                this.errors.add("Error while inspecting the class: " + className + ". The error was: " + e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                this.errors.add("Unable to find the class: " + e.getMessage().replace('/', '.') + " which is required by: " + className + ". You may need to add more classes to the model.");
            }
        }
        HashSet<String> declaredTypes = new HashSet<String>();
        for (TypeDeclarationDescr td : pkgDescr.getTypeDeclarations()) {
            declaredTypes.add(td.getTypeName());
        }
        for (TypeDeclarationDescr td : pkgDescr.getTypeDeclarations()) {
            if (td.getFields().size() <= 0) continue;
            String declaredType = td.getTypeName();
            this.builder.addFactType(declaredType, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS);
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Map.Entry f : td.getFields().entrySet()) {
                String fieldName = (String)f.getKey();
                fieldNames.add(fieldName);
                String fieldClass = ((TypeFieldDescr)f.getValue()).getPattern().getObjectType();
                if (declaredTypes.contains(fieldClass)) {
                    this.builder.addFieldType(declaredType + "." + fieldName, fieldClass, null);
                    continue;
                }
                try {
                    Class clz = this.resolver.resolveType(fieldClass);
                    this.builder.addFieldType(declaredType + "." + fieldName, this.translateClassToGenericType(clz), clz);
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Class of field not found: " + fieldClass);
                }
            }
            this.builder.addFieldsForType(declaredType, fieldNames.toArray(new String[fieldNames.size()]));
        }
        this.populateFactTemplateTypes(pkgDescr, this.resolver);
    }

    private void populateFactTemplateTypes(PackageDescr pkgDescr, ClassTypeResolver resolver) {
        for (FactTemplateDescr templ : pkgDescr.getFactTemplates()) {
            String factType = templ.getName();
            this.builder.addFactType(factType, ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS);
            Object[] fields = new String[templ.getFields().size()];
            int index = 0;
            for (FieldTemplateDescr fieldDescr : templ.getFields()) {
                fields[index++] = fieldDescr.getName();
                String fieldType = fieldDescr.getClassType();
                Class fieldTypeClass = null;
                try {
                    fieldTypeClass = resolver.resolveType(fieldType);
                }
                catch (ClassNotFoundException e) {
                    this.errors.add("Fact template field type not found: " + fieldType);
                }
                this.builder.addFieldType(factType + "." + fieldDescr.getName(), this.translateClassToGenericType(fieldTypeClass), fieldTypeClass);
            }
            Arrays.sort(fields);
            this.builder.addFieldsForType(factType, (String[])fields);
        }
    }

    private Class loadClass(String className, List jars) {
        Class clazz = null;
        try {
            clazz = this.resolver.resolveType(className);
        }
        catch (ClassFormatError e1) {
            clazz = this.loadClass(className, jars, clazz);
        }
        catch (ClassNotFoundException e1) {
            clazz = this.loadClass(className, jars, clazz);
        }
        return clazz;
    }

    private Class loadClass(String className, List jars, Class clazz) {
        try {
            this.addJars(jars);
            clazz = this.resolver.resolveType(className);
        }
        catch (Exception e) {
            this.errors.add("Class not found: " + className);
        }
        return clazz;
    }

    private void loadClassFields(Class<?> clazz, String shortTypeName) throws IOException {
        if (clazz == null) {
            return;
        }
        ClassFieldInspector inspector = new ClassFieldInspector(clazz);
        TreeSet<String> fieldSet = new TreeSet<String>();
        fieldSet.addAll(inspector.getFieldNames().keySet());
        fieldSet.add("this");
        this.builder.addFieldsForType(shortTypeName, this.removeIrrelevantFields(fieldSet));
        Method[] methods = clazz.getMethods();
        ArrayList<String> modifierStrings = new ArrayList<String>();
        HashMap<String, FieldAccessorsAndMutators> accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
        for (Method method : methods) {
            String factField;
            String name;
            modifierStrings.add(method.getName());
            if (method.getParameterTypes().length > 0) {
                name = method.getName();
                if (name.startsWith("set")) {
                    name = Introspector.decapitalize(name.substring(3));
                }
                if (accessorsAndMutators.get(factField = shortTypeName + "." + name) == FieldAccessorsAndMutators.ACCESSOR) {
                    accessorsAndMutators.put(factField, FieldAccessorsAndMutators.BOTH);
                    continue;
                }
                accessorsAndMutators.put(factField, FieldAccessorsAndMutators.MUTATOR);
                continue;
            }
            if (method.getReturnType().equals("void")) continue;
            name = method.getName();
            if (name.startsWith("get")) {
                name = Introspector.decapitalize(name.substring(3));
            } else if (name.startsWith("is")) {
                name = Introspector.decapitalize(name.substring(2));
            }
            factField = shortTypeName + "." + name;
            if (accessorsAndMutators.get(factField) == FieldAccessorsAndMutators.MUTATOR) {
                accessorsAndMutators.put(factField, FieldAccessorsAndMutators.BOTH);
                continue;
            }
            accessorsAndMutators.put(shortTypeName + "." + name, FieldAccessorsAndMutators.ACCESSOR);
        }
        String[] modifiers = new String[modifierStrings.size()];
        modifierStrings.toArray(modifiers);
        this.builder.addModifiersForType(shortTypeName, modifiers);
        this.builder.addFieldAccessorsAndMutatorsForField(accessorsAndMutators);
        fieldSet.remove("this");
        this.builder.addFieldType(shortTypeName + ".this", "Object", clazz);
        for (String field : fieldSet) {
            Class type = (Class)inspector.getFieldTypes().get(field);
            String fieldType = this.translateClassToGenericType(type);
            this.builder.addFieldType(shortTypeName + "." + field, fieldType, type);
            Field f = (Field)inspector.getFieldTypesField().get(field);
            this.builder.addFieldTypeField(shortTypeName + "." + field, f);
        }
        ClassMethodInspector methodInspector = new ClassMethodInspector(clazz, this);
        List<MethodInfo> methodInfos = methodInspector.getMethodInfos();
        for (MethodInfo mi : methodInfos) {
            String genericType = mi.getParametricReturnType();
            if (genericType == null) continue;
            this.builder.putParametricFieldType(shortTypeName + "." + mi.getNameWithParameters(), genericType);
        }
        this.builder.getInstance().addMethodInfo(shortTypeName, methodInfos);
    }

    String getShortNameOfClass(String clazz) {
        return clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    String[] removeIrrelevantFields(Collection<String> fields) {
        ArrayList<String> result = new ArrayList<String>();
        for (String field : fields) {
            if (field.equals("class") || field.equals("hashCode") || field.equals("toString")) continue;
            result.add(field);
        }
        return result.toArray(new String[result.size()]);
    }

    private void addJars(List<JarInputStream> jars) throws IOException {
        for (JarInputStream jis : jars) {
            JarEntry entry;
            byte[] buf = new byte[1024];
            while ((entry = jis.getNextJarEntry()) != null) {
                int len;
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                this.loader.addResource(entry.getName(), out.toByteArray());
            }
        }
    }

    @Override
    public String translateClassToGenericType(Class<?> type) {
        String fieldType = null;
        if (type != null) {
            if (type.isPrimitive() && type != Boolean.TYPE) {
                fieldType = "Numeric";
            } else if (Number.class.isAssignableFrom(type)) {
                fieldType = "Numeric";
            } else if (String.class.isAssignableFrom(type)) {
                fieldType = "String";
            } else if (Collection.class.isAssignableFrom(type)) {
                fieldType = "Collection";
            } else if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                fieldType = "Boolean";
            } else if (Date.class.isAssignableFrom(type)) {
                fieldType = "Date";
            } else if (Comparable.class.isAssignableFrom(type)) {
                fieldType = "Comparable";
            } else {
                try {
                    Class clazz = this.resolver.resolveType(type.getName());
                    fieldType = clazz.getSimpleName();
                }
                catch (ClassNotFoundException e) {
                    fieldType = "Object";
                }
            }
        }
        return fieldType;
    }

    public void addExternalImportDescrProvider(ExternalImportDescrProvider provider) {
        this.externalImportDescrProviders.add(provider);
    }

    public Set<ImportDescr> getExternalImportDescrs() {
        HashSet<ImportDescr> result = new HashSet<ImportDescr>();
        for (ExternalImportDescrProvider externalImportDescrProvider : this.externalImportDescrProviders) {
            result.addAll(externalImportDescrProvider.getImportDescrs());
        }
        return result;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExternalImportDescrProvider {
        public Set<ImportDescr> getImportDescrs();
    }
}

