/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollection;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollectionIndex;
import org.drools.ide.common.client.modeldriven.brl.ExpressionField;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionGlobalVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionMethod;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVariable;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.util.BRLPersistence;

public class BRXMLPersistence
implements BRLPersistence {
    private XStream xt = new XStream((HierarchicalStreamDriver)new DomDriver());
    private static final BRLPersistence INSTANCE = new BRXMLPersistence();

    protected BRXMLPersistence() {
        this.xt.alias("rule", RuleModel.class);
        this.xt.alias("fact", FactPattern.class);
        this.xt.alias("retract", ActionRetractFact.class);
        this.xt.alias("assert", ActionInsertFact.class);
        this.xt.alias("modify", ActionUpdateField.class);
        this.xt.alias("setField", ActionSetField.class);
        this.xt.alias("dslSentence", DSLSentence.class);
        this.xt.alias("compositePattern", CompositeFactPattern.class);
        this.xt.alias("fromCompositePattern", FromCompositeFactPattern.class);
        this.xt.alias("fromCollectCompositePattern", FromCollectCompositeFactPattern.class);
        this.xt.alias("fromAccumulateCompositePattern", FromAccumulateCompositeFactPattern.class);
        this.xt.alias("metadata", RuleMetadata.class);
        this.xt.alias("attribute", RuleAttribute.class);
        this.xt.alias("fieldValue", ActionFieldValue.class);
        this.xt.alias("connectiveConstraint", ConnectiveConstraint.class);
        this.xt.alias("fieldConstraint", SingleFieldConstraint.class);
        this.xt.alias("compositeConstraint", CompositeFieldConstraint.class);
        this.xt.alias("assertLogical", ActionInsertLogicalFact.class);
        this.xt.alias("freeForm", FreeFormLine.class);
        this.xt.alias("addToGlobal", ActionGlobalCollectionAdd.class);
        this.xt.alias("expression", ExpressionFormLine.class);
        this.xt.alias("field", ExpressionField.class);
        this.xt.alias("method", ExpressionMethod.class);
        this.xt.alias("collection", ExpressionCollection.class);
        this.xt.alias("collectionIndex", ExpressionCollectionIndex.class);
        this.xt.alias("text", ExpressionText.class);
        this.xt.alias("global", ExpressionGlobalVariable.class);
        this.xt.alias("variable", ExpressionVariable.class);
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(RuleModel model) {
        return this.xt.toXML((Object)model);
    }

    public RuleModel unmarshal(String xml) {
        if (xml == null || xml.trim().length() == 0) {
            return this.createEmptyModel();
        }
        RuleModel rm = (RuleModel)this.xt.fromXML(xml);
        if (rm.metadataList == null) {
            rm.metadataList = new RuleMetadata[0];
        }
        this.updateMethodCall(rm);
        return rm;
    }

    protected RuleModel createEmptyModel() {
        return new RuleModel();
    }

    private RuleModel updateMethodCall(RuleModel model) {
        for (int i = 0; i < model.rhs.length; ++i) {
            if (!(model.rhs[i] instanceof ActionCallMethod)) continue;
            ActionCallMethod action = (ActionCallMethod)model.rhs[i];
            if (action.methodName != null && !"".equals(action.methodName) || action.fieldValues == null || action.fieldValues.length < 1) continue;
            action.methodName = action.fieldValues[0].field;
            action.fieldValues = new ActionFieldValue[0];
            action.state = 1;
        }
        return model;
    }
}

