/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;

public class SuggestionCompletionEngineTest
extends TestCase {
    public void testNestedImports() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList());
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
    }

    public void testStringNonNumeric() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.Alert";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList());
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("Alert", "message"));
    }

    public void testDataEnums() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        ArrayList<String> enums = new ArrayList<String>();
        enums.add("'Person.age' : [42, 43] \n 'Person.sex' : ['M', 'F']");
        enums.add("'Driver.sex' : ['M', 'F']");
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), enums);
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)engine.getDataEnumListsSize());
        String[] items = engine.getDataEnumList("Person.age");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"42", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"43", (String)items[1]);
        items = engine.getEnums((FactPattern)new FactPattern((String)"Person"), (String)"age").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"42", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"43", (String)items[1]);
        SuggestionCompletionEngineTest.assertNull((Object)engine.getEnums(new FactPattern("Nothing"), "age"));
        SuggestionCompletionEngineTest.assertEquals(null, (Object)engine.getEnums(new FactPattern("Something"), "else"));
    }

    public void testDataEnums3() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.NestedClass";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        ArrayList<String> enums = new ArrayList<String>();
        enums.add("'Fact.f1' : ['a1', 'a2'] \n 'Fact.f2' : ['def1', 'def2', 'def3'] \n 'Fact.f2[f1=a2]' : ['c1', 'c2']");
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), enums);
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("SuggestionCompletionEngineTest$NestedClass", "name"));
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint f1 = new SingleFieldConstraint("f1");
        f1.setValue("a1");
        pat.addConstraint((FieldConstraint)f1);
        pat.addConstraint((FieldConstraint)new SingleFieldConstraint("f2"));
        DropDownData data = engine.getEnums(pat, "f2");
        SuggestionCompletionEngineTest.assertNotNull((Object)data);
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)data.fixedList.length);
    }

    public void testDataEnums2() {
        String pkg = "package org.test\n import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngineTest.Fact";
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        ArrayList<String> enums = new ArrayList<String>();
        enums.add("'Fact.field1' : ['val1', 'val2'] 'Fact.field2' : ['val3', 'val4'] 'Fact.field2[field1=val1]' : ['f1val1a', 'f1val1b'] 'Fact.field2[field1=val2]' : ['f1val2a', 'f1val2b']");
        SuggestionCompletionEngine engine = loader.getSuggestionEngine(pkg, new ArrayList(), new ArrayList(), enums);
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("SuggestionCompletionEngineTest$Fact", "field1"));
        SuggestionCompletionEngineTest.assertEquals((String)"String", (String)engine.getFieldType("SuggestionCompletionEngineTest$Fact", "field2"));
        SuggestionCompletionEngineTest.assertEquals((int)4, (int)engine.getDataEnumListsSize());
        String[] items = engine.getDataEnumList("Fact.field2");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"val3", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"val4", (String)items[1]);
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field2");
        pat.addConstraint((FieldConstraint)sfc);
        items = engine.getEnums((FactPattern)pat, (String)"field2").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"val3", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"val4", (String)items[1]);
        items = engine.getDataEnumList("Fact.field1");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"val1", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"val2", (String)items[1]);
        items = engine.getEnums((FactPattern)new FactPattern((String)"Fact"), (String)"field1").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)items.length);
        SuggestionCompletionEngineTest.assertEquals((String)"val1", (String)items[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"val2", (String)items[1]);
    }

    public void testCompletions() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setFactTypes(new String[]{"Person", "Vehicle"});
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Person", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("rank", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Comparable"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
                this.put("Vehicle", new ModelField[]{new ModelField("make", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String"), new ModelField("type", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        com.setGlobalVariables((Map)new HashMap<String, String>(){
            {
                this.put("bar", "Person");
                this.put("baz", "Vehicle");
            }
        });
        String[] c = com.getConditionalElements();
        SuggestionCompletionEngineTest.assertEquals((String)"not", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"exists", (String)c[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"or", (String)c[2]);
        c = com.getFactTypes();
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        this.assertContains("Person", c);
        this.assertContains("Vehicle", c);
        c = com.getFieldCompletions("Person");
        SuggestionCompletionEngineTest.assertEquals((String)"age", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"rank", (String)c[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"name", (String)c[2]);
        c = com.getFieldCompletions("Vehicle");
        SuggestionCompletionEngineTest.assertEquals((String)"type", (String)c[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"make", (String)c[0]);
        c = com.getOperatorCompletions("Person", "name");
        SuggestionCompletionEngineTest.assertEquals((int)4, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"==", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"!=", (String)c[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"matches", (String)c[2]);
        c = com.getOperatorCompletions("Person", "age");
        SuggestionCompletionEngineTest.assertEquals((int)6, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)c[0], (String)"==");
        SuggestionCompletionEngineTest.assertEquals((String)c[1], (String)"!=");
        SuggestionCompletionEngineTest.assertEquals((String)c[2], (String)"<");
        SuggestionCompletionEngineTest.assertEquals((String)c[3], (String)">");
        c = com.getOperatorCompletions("Person", "rank");
        SuggestionCompletionEngineTest.assertEquals((int)6, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)c[0], (String)"==");
        SuggestionCompletionEngineTest.assertEquals((String)c[1], (String)"!=");
        SuggestionCompletionEngineTest.assertEquals((String)c[2], (String)"<");
        SuggestionCompletionEngineTest.assertEquals((String)c[3], (String)">");
        c = com.getConnectiveOperatorCompletions("Vehicle", "make");
        SuggestionCompletionEngineTest.assertEquals((int)5, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"|| ==", (String)c[0]);
        c = com.getGlobalVariables();
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"baz", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"bar", (String)c[1]);
        c = com.getFieldCompletionsForGlobalVariable("bar");
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"age", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"rank", (String)c[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"name", (String)c[2]);
        c = com.getFieldCompletionsForGlobalVariable("baz");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"make", (String)c[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"type", (String)c[1]);
        c = com.getOperatorCompletions("Person", "wankle");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)c.length);
        SuggestionCompletionEngineTest.assertEquals((String)"Numeric", (String)com.getFieldType("Person", "age"));
    }

    public void testAdd() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setFactTypes(new String[]{"Foo"});
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Foo", new ModelField[]{new ModelField("a", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)com.getFactTypes().length);
        SuggestionCompletionEngineTest.assertEquals((String)"Foo", (String)com.getFactTypes()[0]);
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)com.getFieldCompletions("Foo").length);
        SuggestionCompletionEngineTest.assertEquals((String)"a", (String)com.getFieldCompletions("Foo")[0]);
    }

    public void testSmartEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        sce.putDataEnumList("Fact.value[type=sex]", new String[]{"M", "F"});
        sce.putDataEnumList("Fact.value[type=colour]", new String[]{"RED", "WHITE", "BLUE"});
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("type");
        sfc.setValue("sex");
        pat.addConstraint((FieldConstraint)sfc);
        String[] result = sce.getEnums((FactPattern)pat, (String)"value").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"M", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"F", (String)result[1]);
        pat = new FactPattern("Fact");
        sfc = new SingleFieldConstraint("type");
        sfc.setValue("colour");
        pat.addConstraint((FieldConstraint)sfc);
        result = sce.getEnums((FactPattern)pat, (String)"value").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"RED", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"WHITE", (String)result[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"BLUE", (String)result[2]);
        result = sce.getEnums((FactPattern)pat, (String)"type").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"sex", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"colour", (String)result[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("type", "sex", "blah"), new ActionFieldValue("value", null, "blah")};
        result = sce.getEnums((String)"Fact", (ActionFieldValue[])vals, (String)"value").fixedList;
        SuggestionCompletionEngineTest.assertNotNull((Object)result);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"M", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"F", (String)result[1]);
        SuggestionCompletionEngineTest.assertNull((Object)sce.getEnums("Nothing", vals, "value"));
    }

    public void testSmartEnumsDependingOfSeveralFieldsTwo() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.field1", new String[]{"a1", "a2"});
        sce.putDataEnumList("Fact.field2", new String[]{"b1", "b2"});
        sce.putDataEnumList("Fact.field3[field1=a1,field2=b1]", new String[]{"c1", "c2", "c3"});
        sce.putDataEnumList("Fact.field4[field1=a1]", new String[]{"d1", "d2"});
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setValue("a1");
        pat.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("field2");
        sfc2.setValue("b1");
        pat.addConstraint((FieldConstraint)sfc2);
        String[] result = sce.getEnums((FactPattern)pat, (String)"field3").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)3, (int)result.length);
        SuggestionCompletionEngineTest.assertEquals((String)"c1", (String)result[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"c2", (String)result[1]);
        SuggestionCompletionEngineTest.assertEquals((String)"c3", (String)result[2]);
    }

    public void testSmartEnumsDependingOfSeveralFieldsFive() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.field1", new String[]{"a1", "a2"});
        sce.putDataEnumList("Fact.field2", new String[]{"b1", "b2"});
        sce.putDataEnumList("Fact.field3", new String[]{"c1", "c2", "c3"});
        sce.putDataEnumList("Fact.longerField4", new String[]{"d1", "d2"});
        sce.putDataEnumList("Fact.field5", new String[]{"e1", "e2"});
        sce.putDataEnumList("Fact.field6[field1=a1, field2=b2, field3=c3,longerField4=d1,field5=e2]", new String[]{"f1", "f2"});
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("field1");
        sfc.setValue("a1");
        pat.addConstraint((FieldConstraint)sfc);
        SingleFieldConstraint sfc2 = new SingleFieldConstraint("field2");
        sfc2.setValue("b2");
        pat.addConstraint((FieldConstraint)sfc2);
        SingleFieldConstraint sfc3 = new SingleFieldConstraint("field3");
        sfc3.setValue("c3");
        pat.addConstraint((FieldConstraint)sfc3);
        SingleFieldConstraint sfc4 = new SingleFieldConstraint("longerField4");
        sfc4.setValue("d1");
        pat.addConstraint((FieldConstraint)sfc4);
        SuggestionCompletionEngineTest.assertNull((Object)sce.getEnums(pat, "field6"));
        SingleFieldConstraint sfc5 = new SingleFieldConstraint("field5");
        sfc5.setValue("e2");
        pat.addConstraint((FieldConstraint)sfc5);
        String[] result2 = sce.getEnums((FactPattern)pat, (String)"field6").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)result2.length);
        SuggestionCompletionEngineTest.assertEquals((String)"f1", (String)result2[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2", (String)result2[1]);
    }

    public void testSmarterLookupEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        sce.putDataEnumList("Fact.value[f1, f2]", new String[]{"select something from database where x=@{f1} and y=@{f2}"});
        FactPattern fp = new FactPattern("Fact");
        String[] drops = sce.getEnums((FactPattern)fp, (String)"type").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)drops.length);
        SuggestionCompletionEngineTest.assertEquals((String)"sex", (String)drops[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"colour", (String)drops[1]);
        Map lookupFields = sce.loadDataEnumLookupFields();
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)lookupFields.size());
        String[] flds = (String[])lookupFields.get("Fact.value");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)flds.length);
        SuggestionCompletionEngineTest.assertEquals((String)"f1", (String)flds[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2", (String)flds[1]);
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("f1");
        sfc.setValue("f1val");
        pat.addConstraint((FieldConstraint)sfc);
        sfc = new SingleFieldConstraint("f2");
        sfc.setValue("f2val");
        pat.addConstraint((FieldConstraint)sfc);
        DropDownData dd = sce.getEnums(pat, "value");
        SuggestionCompletionEngineTest.assertNull((Object)dd.fixedList);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.queryExpression);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.valuePairs);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)dd.valuePairs.length);
        SuggestionCompletionEngineTest.assertEquals((String)"select something from database where x=@{f1} and y=@{f2}", (String)dd.queryExpression);
        SuggestionCompletionEngineTest.assertEquals((String)"f1=f1val", (String)dd.valuePairs[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2=f2val", (String)dd.valuePairs[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("f1", "f1val", "blah"), new ActionFieldValue("f2", "f2val", "blah")};
        dd = sce.getEnums("Fact", vals, "value");
        SuggestionCompletionEngineTest.assertNull((Object)dd.fixedList);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.queryExpression);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.valuePairs);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)dd.valuePairs.length);
        SuggestionCompletionEngineTest.assertEquals((String)"select something from database where x=@{f1} and y=@{f2}", (String)dd.queryExpression);
        SuggestionCompletionEngineTest.assertEquals((String)"f1=f1val", (String)dd.valuePairs[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2=f2val", (String)dd.valuePairs[1]);
    }

    public void testSmarterLookupEnumsDifferentOrder() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        sce.putDataEnumList("Fact.value[e1, e2]", new String[]{"select something from database where x=@{e1} and y=@{e2}"});
        sce.putDataEnumList("Fact.value[f1, f2]", new String[]{"select something from database where x=@{f1} and y=@{f2}"});
        FactPattern fp = new FactPattern("Fact");
        String[] drops = sce.getEnums((FactPattern)fp, (String)"type").fixedList;
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)drops.length);
        SuggestionCompletionEngineTest.assertEquals((String)"sex", (String)drops[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"colour", (String)drops[1]);
        Map lookupFields = sce.loadDataEnumLookupFields();
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)lookupFields.size());
        String[] flds = (String[])lookupFields.get("Fact.value");
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)flds.length);
        SuggestionCompletionEngineTest.assertEquals((String)"f1", (String)flds[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2", (String)flds[1]);
        FactPattern pat = new FactPattern("Fact");
        SingleFieldConstraint sfc = new SingleFieldConstraint("f1");
        sfc.setValue("f1val");
        pat.addConstraint((FieldConstraint)sfc);
        sfc = new SingleFieldConstraint("f2");
        sfc.setValue("f2val");
        pat.addConstraint((FieldConstraint)sfc);
        DropDownData dd = sce.getEnums(pat, "value");
        SuggestionCompletionEngineTest.assertNull((Object)dd.fixedList);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.queryExpression);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.valuePairs);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)dd.valuePairs.length);
        SuggestionCompletionEngineTest.assertEquals((String)"select something from database where x=@{f1} and y=@{f2}", (String)dd.queryExpression);
        SuggestionCompletionEngineTest.assertEquals((String)"f1=f1val", (String)dd.valuePairs[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2=f2val", (String)dd.valuePairs[1]);
        ActionFieldValue[] vals = new ActionFieldValue[]{new ActionFieldValue("f1", "f1val", "blah"), new ActionFieldValue("f2", "f2val", "blah")};
        dd = sce.getEnums("Fact", vals, "value");
        SuggestionCompletionEngineTest.assertNull((Object)dd.fixedList);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.queryExpression);
        SuggestionCompletionEngineTest.assertNotNull((Object)dd.valuePairs);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)dd.valuePairs.length);
        SuggestionCompletionEngineTest.assertEquals((String)"select something from database where x=@{f1} and y=@{f2}", (String)dd.queryExpression);
        SuggestionCompletionEngineTest.assertEquals((String)"f1=f1val", (String)dd.valuePairs[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"f2=f2val", (String)dd.valuePairs[1]);
    }

    public void testSimpleEnums() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setDataEnumLists(new HashMap());
        sce.putDataEnumList("Fact.type", new String[]{"sex", "colour"});
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)sce.getEnumValues("Fact", "type").length);
        SuggestionCompletionEngineTest.assertEquals((String)"sex", (String)sce.getEnumValues("Fact", "type")[0]);
        SuggestionCompletionEngineTest.assertEquals((String)"colour", (String)sce.getEnumValues("Fact", "type")[1]);
    }

    private void assertContains(String string, String[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (!string.equals(c[i])) continue;
            return;
        }
        SuggestionCompletionEngineTest.fail((String)("String array did not contain: " + string));
    }

    public void testGlobalAndFacts() {
        SuggestionCompletionEngine com = new SuggestionCompletionEngine();
        com.setGlobalVariables((Map)new HashMap<String, String>(){
            {
                this.put("y", "Foo");
            }
        });
        com.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Foo", new ModelField[]{new ModelField("a", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        SuggestionCompletionEngineTest.assertFalse((boolean)com.isGlobalVariable("x"));
        SuggestionCompletionEngineTest.assertTrue((boolean)com.isGlobalVariable("y"));
    }

    public void testDataDropDown() {
        SuggestionCompletionEngineTest.assertNull((Object)DropDownData.create(null));
        SuggestionCompletionEngineTest.assertNull((Object)DropDownData.create(null, null));
        SuggestionCompletionEngineTest.assertNotNull((Object)DropDownData.create((String[])new String[]{"hey"}));
        SuggestionCompletionEngineTest.assertNotNull((Object)DropDownData.create((String)"abc", (String[])new String[]{"hey"}));
    }

    public void testFilter() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFactTypes(new String[]{"Person", "Vehicle"});
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Person", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric")});
                this.put("Vehicle", new ModelField[]{new ModelField("make", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)sce.getFactTypes().length);
        sce.setFactTypeFilter(new FactTypeFilter(){

            public boolean filter(String originalFact) {
                return "Person".equals(originalFact);
            }
        });
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)sce.getFactTypes().length);
        sce.setFilteringFacts(false);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)sce.getFactTypes().length);
        sce.setFilteringFacts(true);
        SuggestionCompletionEngineTest.assertEquals((int)1, (int)sce.getFactTypes().length);
        sce.setFactTypeFilter(null);
        SuggestionCompletionEngineTest.assertEquals((int)2, (int)sce.getFactTypes().length);
    }

    public static class Fact {
        private String field1;
        private String field2;

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }
    }

    public static class NestedClass {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

