/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven;

import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

public class FactPatternTest
extends TestCase {
    public void testAddConstraint() {
        FactPattern p = new FactPattern();
        SingleFieldConstraint x = new SingleFieldConstraint("x");
        p.addConstraint((FieldConstraint)x);
        FactPatternTest.assertEquals((int)1, (int)p.constraintList.constraints.length);
        FactPatternTest.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        SingleFieldConstraint y = new SingleFieldConstraint("y");
        p.addConstraint((FieldConstraint)y);
        FactPatternTest.assertEquals((int)2, (int)p.constraintList.constraints.length);
        FactPatternTest.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        FactPatternTest.assertEquals((Object)y, (Object)p.constraintList.constraints[1]);
    }

    public void testWithCompositeNesting() {
        FactPattern p = new FactPattern();
        SingleFieldConstraint x = new SingleFieldConstraint("x");
        p.addConstraint((FieldConstraint)x);
        FactPatternTest.assertEquals((int)1, (int)p.constraintList.constraints.length);
        FactPatternTest.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        CompositeFieldConstraint y = new CompositeFieldConstraint();
        y.addConstraint((FieldConstraint)new SingleFieldConstraint("y"));
        y.addConstraint((FieldConstraint)new SingleFieldConstraint("z"));
        p.addConstraint((FieldConstraint)y);
        FactPatternTest.assertEquals((int)2, (int)p.constraintList.constraints.length);
        FactPatternTest.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
        FactPatternTest.assertEquals((Object)y, (Object)p.constraintList.constraints[1]);
    }

    public void testRemoveConstraint() {
        FactPattern p = new FactPattern();
        SingleFieldConstraint x = new SingleFieldConstraint("x");
        p.addConstraint((FieldConstraint)x);
        SingleFieldConstraint y = new SingleFieldConstraint("y");
        p.addConstraint((FieldConstraint)y);
        FactPatternTest.assertEquals((int)2, (int)p.constraintList.constraints.length);
        p.removeConstraint(1);
        FactPatternTest.assertEquals((int)1, (int)p.constraintList.constraints.length);
        FactPatternTest.assertEquals((Object)x, (Object)p.constraintList.constraints[0]);
    }

    public void testIsBound() {
        FactPattern pat = new FactPattern();
        pat.boundName = "x";
        FactPatternTest.assertTrue((boolean)pat.isBound());
        pat = new FactPattern();
        FactPatternTest.assertFalse((boolean)pat.isBound());
    }

    public void testGetFieldConstraints() {
        FactPattern pat = new FactPattern();
        FactPatternTest.assertEquals((int)0, (int)pat.getFieldConstraints().length);
        FactPatternTest.assertNull((Object)pat.constraintList);
        pat.addConstraint((FieldConstraint)new SingleFieldConstraint());
        FactPatternTest.assertNotNull((Object)pat.constraintList);
        FactPatternTest.assertEquals((int)1, (int)pat.getFieldConstraints().length);
    }
}

