/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.modeldriven.dt;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;

public class GuidedDecisionTableTest
extends TestCase {
    public void testValueLists() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.factField = "name";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        ConditionCol c1_ = new ConditionCol();
        c1_.boundName = "c1";
        c1_.factType = "Driver";
        c1_.factField = "name";
        c1_.constraintValueType = 3;
        dt.conditionCols.add(c1_);
        ConditionCol c1__ = new ConditionCol();
        c1__.boundName = "c1";
        c1__.factType = "Driver";
        c1__.factField = "name";
        c1__.constraintValueType = 1;
        c1__.valueList = "one,two,three";
        dt.conditionCols.add(c1__);
        ConditionCol c2 = new ConditionCol();
        c2.boundName = "c2";
        c2.factType = "Driver";
        c2.factField = "nothing";
        c2.constraintValueType = 1;
        dt.conditionCols.add(c2);
        ActionSetFieldCol asf = new ActionSetFieldCol();
        asf.boundName = "c1";
        asf.factField = "name";
        dt.actionCols.add(asf);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "x";
        ins.factField = "rating";
        ins.factType = "Person";
        dt.actionCols.add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.boundName = "x";
        ins_.factField = "rating";
        ins_.factType = "Person";
        ins_.valueList = "one,two,three";
        dt.actionCols.add(ins_);
        ActionSetFieldCol asf_ = new ActionSetFieldCol();
        asf_.boundName = "c1";
        asf_.factField = "goo";
        dt.actionCols.add(asf_);
        ActionSetFieldCol asf__ = new ActionSetFieldCol();
        asf__.boundName = "c1";
        asf__.factField = "goo";
        asf__.valueList = "one,two,three";
        dt.actionCols.add(asf__);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.putDataEnumList("Driver.name", new String[]{"bob", "michael"});
        sce.putDataEnumList("Person.rating", new String[]{"1", "2"});
        String[] r = dt.getValueList((DTColumnConfig)c1, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"bob", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"michael", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)c1_, sce).length);
        r = dt.getValueList((DTColumnConfig)c1__, sce);
        GuidedDecisionTableTest.assertEquals((int)3, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"one", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"two", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((String)"three", (String)r[2]);
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)c2, sce).length);
        r = dt.getValueList((DTColumnConfig)asf, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"bob", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"michael", (String)r[1]);
        r = dt.getValueList((DTColumnConfig)ins, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"1", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"2", (String)r[1]);
        r = dt.getValueList((DTColumnConfig)ins_, sce);
        GuidedDecisionTableTest.assertEquals((int)3, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"one", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"two", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((String)"three", (String)r[2]);
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)asf_, sce).length);
        r = dt.getValueList((DTColumnConfig)asf__, sce);
        GuidedDecisionTableTest.assertEquals((int)3, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"one", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"two", (String)r[1]);
        GuidedDecisionTableTest.assertEquals((String)"three", (String)r[2]);
        AttributeCol at = new AttributeCol();
        at.attr = "no-loop";
        dt.attributeCols.add(at);
        r = dt.getValueList((DTColumnConfig)at, sce);
        GuidedDecisionTableTest.assertEquals((int)2, (int)r.length);
        GuidedDecisionTableTest.assertEquals((String)"true", (String)r[0]);
        GuidedDecisionTableTest.assertEquals((String)"false", (String)r[1]);
        at.attr = "enabled";
        GuidedDecisionTableTest.assertEquals((int)2, (int)dt.getValueList((DTColumnConfig)at, sce).length);
        at.attr = "salience";
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)at, sce).length);
    }

    public void testNumeric() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        GuidedDecisionTable dt = new GuidedDecisionTable();
        AttributeCol at = new AttributeCol();
        at.attr = "salience";
        AttributeCol at_ = new AttributeCol();
        at_.attr = "enabled";
        dt.attributeCols.add(at);
        dt.attributeCols.add(at_);
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.factField = "name";
        c1.operator = "==";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        ConditionCol c1_ = new ConditionCol();
        c1_.boundName = "c1";
        c1_.factType = "Driver";
        c1_.factField = "age";
        c1_.operator = "==";
        c1_.constraintValueType = 1;
        dt.conditionCols.add(c1_);
        ConditionCol c2 = new ConditionCol();
        c2.boundName = "c1";
        c2.factType = "Driver";
        c2.factField = "age";
        c2.constraintValueType = 1;
        dt.conditionCols.add(c2);
        ActionSetFieldCol a = new ActionSetFieldCol();
        a.boundName = "c1";
        a.factField = "name";
        dt.actionCols.add(a);
        ActionSetFieldCol a2 = new ActionSetFieldCol();
        a2.boundName = "c1";
        a2.factField = "age";
        dt.actionCols.add(a2);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "x";
        ins.factType = "Driver";
        ins.factField = "name";
        dt.actionCols.add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.boundName = "x";
        ins_.factType = "Driver";
        ins_.factField = "age";
        dt.actionCols.add(ins_);
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)at, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)at_, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)c1, sce));
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)c1_, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)a, sce));
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)a2, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)ins, sce));
        GuidedDecisionTableTest.assertTrue((boolean)dt.isNumeric((DTColumnConfig)ins_, sce));
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)c2, sce));
    }

    public void testGetType() {
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String"), new ModelField("date", Date.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Date"), new ModelField("approved", Boolean.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Boolean")});
            }
        });
        GuidedDecisionTable dt = new GuidedDecisionTable();
        AttributeCol salienceAttribute = new AttributeCol();
        salienceAttribute.attr = "salience";
        AttributeCol enabledAttribute = new AttributeCol();
        enabledAttribute.attr = "enabled";
        dt.attributeCols.add(salienceAttribute);
        dt.attributeCols.add(enabledAttribute);
        ConditionCol conditionColName = new ConditionCol();
        conditionColName.boundName = "c1";
        conditionColName.factType = "Driver";
        conditionColName.factField = "name";
        conditionColName.operator = "==";
        conditionColName.constraintValueType = 1;
        dt.conditionCols.add(conditionColName);
        ConditionCol conditionColAge = new ConditionCol();
        conditionColAge.boundName = "c1";
        conditionColAge.factType = "Driver";
        conditionColAge.factField = "age";
        conditionColAge.operator = "==";
        conditionColAge.constraintValueType = 1;
        dt.conditionCols.add(conditionColAge);
        ConditionCol conditionColDate = new ConditionCol();
        conditionColDate.boundName = "c1";
        conditionColDate.factType = "Driver";
        conditionColDate.factField = "date";
        conditionColDate.operator = "==";
        conditionColDate.constraintValueType = 1;
        dt.conditionCols.add(conditionColDate);
        ConditionCol conditionColApproved = new ConditionCol();
        conditionColApproved.boundName = "c1";
        conditionColApproved.factType = "Driver";
        conditionColApproved.factField = "approved";
        conditionColApproved.operator = "==";
        conditionColApproved.constraintValueType = 1;
        dt.conditionCols.add(conditionColApproved);
        ConditionCol conditionColAge2 = new ConditionCol();
        conditionColAge2.boundName = "c1";
        conditionColAge2.factType = "Driver";
        conditionColAge2.factField = "age";
        conditionColAge2.constraintValueType = 1;
        dt.conditionCols.add(conditionColAge2);
        ActionSetFieldCol a = new ActionSetFieldCol();
        a.boundName = "c1";
        a.factField = "name";
        dt.actionCols.add(a);
        ActionSetFieldCol a2 = new ActionSetFieldCol();
        a2.boundName = "c1";
        a2.factField = "age";
        dt.actionCols.add(a2);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "x";
        ins.factType = "Driver";
        ins.factField = "name";
        dt.actionCols.add(ins);
        ActionInsertFactCol ins_ = new ActionInsertFactCol();
        ins_.boundName = "x";
        ins_.factType = "Driver";
        ins_.factField = "age";
        dt.actionCols.add(ins_);
        GuidedDecisionTableTest.assertEquals((String)"salience", (String)dt.getType((DTColumnConfig)salienceAttribute, sce));
        GuidedDecisionTableTest.assertEquals((String)"enabled", (String)dt.getType((DTColumnConfig)enabledAttribute, sce));
        GuidedDecisionTableTest.assertEquals((String)"String", (String)dt.getType((DTColumnConfig)conditionColName, sce));
        GuidedDecisionTableTest.assertEquals((String)"Numeric", (String)dt.getType((DTColumnConfig)conditionColAge, sce));
        GuidedDecisionTableTest.assertEquals((String)"Date", (String)dt.getType((DTColumnConfig)conditionColDate, sce));
        GuidedDecisionTableTest.assertEquals((String)"Boolean", (String)dt.getType((DTColumnConfig)conditionColApproved, sce));
        GuidedDecisionTableTest.assertEquals((String)"String", (String)dt.getType((DTColumnConfig)a, sce));
        GuidedDecisionTableTest.assertEquals((String)"Numeric", (String)dt.getType((DTColumnConfig)a2, sce));
        GuidedDecisionTableTest.assertEquals((String)"String", (String)dt.getType((DTColumnConfig)ins, sce));
        GuidedDecisionTableTest.assertEquals((String)"Numeric", (String)dt.getType((DTColumnConfig)ins_, sce));
        GuidedDecisionTableTest.assertEquals((String)"Numeric", (String)dt.getType((DTColumnConfig)conditionColAge2, sce));
    }

    public void testNoConstraintLists() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        ConditionCol c2 = new ConditionCol();
        c2.boundName = "c2";
        c2.factType = "Driver";
        c2.constraintValueType = 1;
        c2.valueList = "a,b,c";
        dt.conditionCols.add(c2);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.putDataEnumList("Driver.name", new String[]{"bob", "michael"});
        GuidedDecisionTableTest.assertEquals((int)0, (int)dt.getValueList((DTColumnConfig)c1, sce).length);
        GuidedDecisionTableTest.assertEquals((int)3, (int)dt.getValueList((DTColumnConfig)c2, sce).length);
    }

    public void testNoConstraintsNumeric() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        ConditionCol c1 = new ConditionCol();
        c1.boundName = "c1";
        c1.factType = "Driver";
        c1.constraintValueType = 1;
        dt.conditionCols.add(c1);
        SuggestionCompletionEngine sce = new SuggestionCompletionEngine();
        sce.setFieldsForTypes((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Driver", new ModelField[]{new ModelField("age", Integer.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "Numeric"), new ModelField("name", String.class.getName(), ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, "String")});
            }
        });
        GuidedDecisionTableTest.assertFalse((boolean)dt.isNumeric((DTColumnConfig)c1, sce));
    }
}

