/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.rules.EnumClass;
import org.drools.ide.common.server.rules.SuggestionCompletionLoader;
import org.drools.lang.descr.ImportDescr;

public class SuggestionCompletionLoaderTest
extends TestCase {
    public void testSuggestionCompLoader() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
    }

    public void testSuggestionCompLoaderWithExtraImportProviders() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        loader.addExternalImportDescrProvider(new SuggestionCompletionLoader.ExternalImportDescrProvider(){

            public Set<ImportDescr> getImportDescrs() {
                return new HashSet<ImportDescr>(){
                    {
                        this.add(new ImportDescr("java.util.List"));
                        this.add(new ImportDescr("java.util.Set"));
                    }
                };
            }
        });
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((int)3, (int)eng.getFactTypes().length);
        List<String> factTypes = Arrays.asList(eng.getFactTypes());
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("List"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("Set"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("Person"));
        eng = loader.getSuggestionEngine("package foo \n import org.drools.Person \n declare GenBean \n   id: int \n name : String \n end \n declare GenBean2 \n list: java.util.List \n gb: GenBean \n end", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertEquals((int)5, (int)eng.getFactTypes().length);
        factTypes = Arrays.asList(eng.getFactTypes());
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("List"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("Set"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("Person"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("GenBean"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("GenBean2"));
    }

    public void testSuggestionCompLoaderWithExtraImportProvidersAndFilters() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        loader.addExternalImportDescrProvider(new SuggestionCompletionLoader.ExternalImportDescrProvider(){

            public Set<ImportDescr> getImportDescrs() {
                return new HashSet<ImportDescr>(){
                    {
                        this.add(new ImportDescr("java.util.List"));
                        this.add(new ImportDescr("java.util.Set"));
                    }
                };
            }
        });
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person \n declare GenBean \n   id: int \n name : String \n end \n declare GenBean2 \n list: java.util.List \n gb: GenBean \n end", new ArrayList(), new ArrayList());
        eng.setFactTypeFilter(new FactTypeFilter(){

            public boolean filter(String originalFact) {
                return originalFact.equals("List") || originalFact.equals("GenBean2");
            }
        });
        eng.setFilteringFacts(true);
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((int)3, (int)eng.getFactTypes().length);
        List<String> factTypes = Arrays.asList(eng.getFactTypes());
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("Set"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("Person"));
        SuggestionCompletionLoaderTest.assertTrue((boolean)factTypes.contains("GenBean"));
    }

    public void testSuggestionCompLoaderWildcards() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        loader.getSuggestionEngine("package foo \n import org.drools.*", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)loader.getErrors().size());
        String err = (String)loader.getErrors().get(0);
        SuggestionCompletionLoaderTest.assertTrue((boolean)err.startsWith("Unable"));
    }

    public void testLoadDifferentFieldTypes() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("SomeFact", "age"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("SomeFact", "likes"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("SomeFact", "name"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("SomeFact", "bigDecimal"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Boolean", (String)eng.getFieldType("SomeFact", "alive"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Date", (String)eng.getFieldType("SomeFact", "date"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Cheese", (String)eng.getFieldType("SomeFact", "cheese"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Boolean", (String)eng.getFieldType("SomeFact", "dead"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Boolean", (String)eng.getFieldType("SomeFact", "alive"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Collection", (String)eng.getFieldType("SomeFact", "factList"));
        SuggestionCompletionLoaderTest.assertEquals((String)"SomeFact", (String)eng.getParametricFieldType("SomeFact", "factList"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Collection", (String)eng.getFieldType("SomeFact", "factListString"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getParametricFieldType("SomeFact", "factListString"));
    }

    public void testLoadDifferentMethodTypes() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((String)List.class.getName(), (String)eng.getMethodClassType("SomeFact", "aMethod(int)"));
        SuggestionCompletionLoaderTest.assertEquals((String)"SomeFact", (String)eng.getParametricFieldType("SomeFact", "aMethod(int)"));
    }

    public void testGeneratedBeans() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n declare GenBean \n   id: int \n name : String \n end \n declare GenBean2 \n list: java.util.List \n gb: GenBean \n end", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertFalse((boolean)loader.hasErrors());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((int)2, (int)eng.getFactTypes().length);
        SuggestionCompletionLoaderTest.assertEquals((String)"GenBean", (String)eng.getFactTypes()[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"GenBean2", (String)eng.getFactTypes()[1]);
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("GenBean", "id"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("GenBean", "name"));
        SuggestionCompletionLoaderTest.assertEquals((String)"GenBean", (String)eng.getFieldType("GenBean2", "gb"));
    }

    public void testGlobal() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n global org.drools.Person p", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertFalse((boolean)loader.hasErrors());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)eng.getGlobalVariables().length);
        SuggestionCompletionLoaderTest.assertEquals((String)"p", (String)eng.getGlobalVariables()[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"Person", (String)eng.getGlobalVariable("p"));
        String[] flds = eng.getModelFields("Person");
        SuggestionCompletionLoaderTest.assertNotNull((Object)flds);
        SuggestionCompletionLoaderTest.assertEquals((int)0, (int)eng.getGlobalCollections().length);
    }

    public void testGlobalCollections() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n global java.util.List ls", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertFalse((boolean)loader.hasErrors());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)eng.getGlobalVariables().length);
        SuggestionCompletionLoaderTest.assertEquals((String)"ls", (String)eng.getGlobalVariables()[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"List", (String)eng.getGlobalVariable("ls"));
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng.getGlobalCollections());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)eng.getGlobalCollections().length);
        SuggestionCompletionLoaderTest.assertEquals((String)"ls", (String)eng.getGlobalCollections()[0]);
    }

    public void testSortOrderOfFields() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        String[] fields = eng.getFieldCompletions("SomeFact");
        SuggestionCompletionLoaderTest.assertEquals((String)"age", (String)fields[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"alive", (String)fields[1]);
        SuggestionCompletionLoaderTest.assertEquals((String)"anEnum", (String)fields[2]);
        SuggestionCompletionLoaderTest.assertEquals((String)"bigDecimal", (String)fields[3]);
    }

    public void testEnumFields() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertTrue((boolean)eng.hasDataEnumLists());
        SuggestionCompletionLoaderTest.assertEquals((int)eng.getDataEnumList("SomeFact.anEnum").length, (int)3);
        String[] a = eng.getDataEnumList("SomeFact.anEnum");
        SuggestionCompletionLoaderTest.assertEquals((String)a[0], (String)("0=" + (Object)((Object)EnumClass.v1)));
        SuggestionCompletionLoaderTest.assertEquals((String)a[1], (String)("1=" + (Object)((Object)EnumClass.v2)));
        SuggestionCompletionLoaderTest.assertEquals((String)a[2], (String)("2=" + (Object)((Object)EnumClass.v3)));
    }

    public void testSortOrderOfFacts() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.ide.common.server.rules.SomeFact\n import org.drools.Person", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        String[] facts = eng.getFactTypes();
        SuggestionCompletionLoaderTest.assertEquals((int)2, (int)facts.length);
        SuggestionCompletionLoaderTest.assertEquals((String)"Person", (String)facts[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"SomeFact", (String)facts[1]);
    }

    public void testTypeDeclarations() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        String header = "";
        header = header + "package foo\n";
        header = header + "declare Applicant\n";
        header = header + "     creditRating: String\n";
        header = header + "     approved: Boolean\n";
        header = header + "     applicationDate: java.util.Date\n";
        header = header + "     age: Integer\n";
        header = header + "     name: String\n";
        header = header + "end\n";
        header = header + "declare LoanApplication\n";
        header = header + "     amount: Integer\n";
        header = header + "     approved: Boolean\n";
        header = header + "     deposit: Integer\n";
        header = header + "     approvedRate: Integer\n";
        header = header + "     lengthYears: Integer\n";
        header = header + "     explanation: String\n";
        header = header + "     insuranceCost: Integer\n";
        header = header + "     applicant: Applicant\n";
        header = header + "end\n";
        SuggestionCompletionEngine eng = loader.getSuggestionEngine(header, new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("Applicant", "creditRating"));
        SuggestionCompletionLoaderTest.assertEquals((String)"java.lang.String", (String)eng.getFieldClassName("Applicant", "creditRating"));
        SuggestionCompletionLoaderTest.assertEquals((Object)ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, (Object)eng.getFieldClassType("Applicant", "creditRating"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("LoanApplication", "deposit"));
        SuggestionCompletionLoaderTest.assertEquals((String)"java.lang.Integer", (String)eng.getFieldClassName("LoanApplication", "deposit"));
        SuggestionCompletionLoaderTest.assertEquals((Object)ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, (Object)eng.getFieldClassType("LoanApplication", "deposit"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Applicant", (String)eng.getFieldType("LoanApplication", "applicant"));
        SuggestionCompletionLoaderTest.assertNull((Object)eng.getFieldClassName("LoanApplication", "applicant"));
        SuggestionCompletionLoaderTest.assertEquals((Object)ModelField.FIELD_CLASS_TYPE.TYPE_DECLARATION_CLASS, (Object)eng.getFieldClassType("LoanApplication", "applicant"));
    }

    public void testLoaderWithExistingClassloader() throws Exception {
        MockClassLoader mcl = new MockClassLoader();
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader((ClassLoader)mcl);
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.foo.Bar", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertTrue((boolean)mcl.called);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MockClassLoader
    extends ClassLoader {
        public boolean called = false;

        MockClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) {
            this.called = true;
            return Object.class;
        }
    }
}

