/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.server.util.BRLPersistenceTest;
import org.drools.ide.common.server.util.GuidedDTXMLPersistence;

public class GuidedDTXMLPersistenceTest
extends TestCase {
    protected void setUp() throws Exception {
        GuidedDTXMLPersistence.getInstance();
    }

    public void testRoundTrip() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.actionCols.add(new ActionInsertFactCol());
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.factField = "foo";
        dt.actionCols.add(set);
        dt.getMetadataCols().add(new MetadataCol());
        dt.attributeCols.add(new AttributeCol());
        dt.conditionCols.add(new ConditionCol());
        dt.data = new String[][]{{"hola"}};
        dt.tableName = "blah";
        dt.descriptionWidth = 42;
        String xml = GuidedDTXMLPersistence.getInstance().marshal(dt);
        System.out.println(xml);
        GuidedDTXMLPersistenceTest.assertNotNull((Object)xml);
        GuidedDTXMLPersistenceTest.assertEquals((int)-1, (int)xml.indexOf("ActionSetField"));
        GuidedDTXMLPersistenceTest.assertEquals((int)-1, (int)xml.indexOf("ConditionCol"));
        GuidedDTXMLPersistenceTest.assertEquals((int)-1, (int)xml.indexOf("GuidedDecisionTable"));
        GuidedDecisionTable dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        GuidedDTXMLPersistenceTest.assertNotNull((Object)dt_);
        GuidedDTXMLPersistenceTest.assertEquals((int)42, (int)dt_.descriptionWidth);
        GuidedDTXMLPersistenceTest.assertEquals((String)"blah", (String)dt_.tableName);
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.getMetadataCols().size());
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.attributeCols.size());
        GuidedDTXMLPersistenceTest.assertEquals((int)2, (int)dt_.actionCols.size());
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.conditionCols.size());
    }

    public void testBackwardsCompatability() throws Exception {
        String xml = BRLPersistenceTest.loadResource("ExistingDecisionTable.xml");
        GuidedDecisionTable dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        GuidedDTXMLPersistenceTest.assertNotNull((Object)dt_);
        GuidedDTXMLPersistenceTest.assertEquals((int)42, (int)dt_.descriptionWidth);
        GuidedDTXMLPersistenceTest.assertEquals((String)"blah", (String)dt_.tableName);
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.getMetadataCols().size());
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.attributeCols.size());
        GuidedDTXMLPersistenceTest.assertEquals((int)2, (int)dt_.actionCols.size());
        GuidedDTXMLPersistenceTest.assertEquals((int)1, (int)dt_.conditionCols.size());
        GuidedDTXMLPersistenceTest.assertTrue((boolean)(dt_.actionCols.get(1) instanceof ActionSetFieldCol));
        ActionSetFieldCol asf = (ActionSetFieldCol)dt_.actionCols.get(1);
        GuidedDTXMLPersistenceTest.assertEquals((String)"foo", (String)asf.factField);
        GuidedDTXMLPersistenceTest.assertEquals((boolean)false, (boolean)asf.update);
    }
}

