/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import junit.framework.TestCase;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.server.util.SuggestionCompletionEngineBuilder;
import org.drools.lang.dsl.DSLMappingEntry;
import org.mockito.Mockito;

public class SuggestionCompletionEngineBuilderTest
extends TestCase {
    SuggestionCompletionEngineBuilder builder = new SuggestionCompletionEngineBuilder();

    protected void setUp() throws Exception {
        super.setUp();
        this.builder.newCompletionEngine();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddDSLSentence() {
        String input = "{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?";
        this.builder.addDSLActionSentence("{This} is a {pattern} considered pretty \\{{easy}\\} by most \\{people\\}. What do you {say}?");
        this.builder.addDSLConditionSentence("foo bar");
        SuggestionCompletionEngine engine = this.builder.getInstance();
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.actionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.conditionDSLSentences.length);
    }

    public void testAddSentenceMultipleTypes() {
        DSLMappingEntry mapping1 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping1");
        DSLMappingEntry mapping2 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping2");
        DSLMappingEntry mapping3 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping3");
        DSLMappingEntry mapping4 = (DSLMappingEntry)Mockito.mock(DSLMappingEntry.class, (String)"mapping4");
        Mockito.when((Object)mapping1.getSection()).thenReturn((Object)DSLMappingEntry.CONDITION);
        Mockito.when((Object)mapping1.getMappingKey()).thenReturn((Object)"cond");
        Mockito.when((Object)mapping2.getSection()).thenReturn((Object)DSLMappingEntry.CONSEQUENCE);
        Mockito.when((Object)mapping2.getMappingKey()).thenReturn((Object)"cons");
        Mockito.when((Object)mapping3.getSection()).thenReturn((Object)DSLMappingEntry.ANY);
        Mockito.when((Object)mapping3.getMappingKey()).thenReturn((Object)"any");
        Mockito.when((Object)mapping4.getSection()).thenReturn((Object)DSLMappingEntry.KEYWORD);
        Mockito.when((Object)mapping4.getMappingKey()).thenReturn((Object)"key");
        this.builder.addDSLMapping(mapping1);
        this.builder.addDSLMapping(mapping2);
        this.builder.addDSLMapping(mapping3);
        this.builder.addDSLMapping(mapping4);
        SuggestionCompletionEngine engine = this.builder.getInstance();
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.actionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.conditionDSLSentences.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.keywordDSLItems.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((int)1, (int)engine.anyScopeDSLItems.length);
        SuggestionCompletionEngineBuilderTest.assertEquals((String)"cond", (String)engine.conditionDSLSentences[0].sentence);
    }
}

