/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.ArrayList;
import java.util.HashSet;
import org.drools.Cheese;
import org.drools.StatefulSession;
import org.drools.event.AgendaEventListener;
import org.drools.testframework.RuleUnit;
import org.drools.testframework.TestingEventListener;

public class TestingEventListenerTest
extends RuleUnit {
    public void testInclusive() throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add("rule1");
        set.add("rule2");
        StatefulSession session = this.getWorkingMemory("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, true));
        TestingEventListenerTest.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        TestingEventListenerTest.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        TestingEventListenerTest.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        TestingEventListenerTest.assertFalse((boolean)ls.firingCounts.containsKey("rule4"));
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, true));
        TestingEventListenerTest.assertEquals((Object)new Integer(2), (Object)((Integer)ls.firingCounts.get("rule1")));
        TestingEventListenerTest.assertEquals((Object)new Integer(2), (Object)((Integer)ls.firingCounts.get("rule2")));
        TestingEventListenerTest.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        TestingEventListenerTest.assertEquals((long)4L, (long)ls.totalFires);
    }

    public void testExclusive() throws Exception {
        HashSet<String> set = new HashSet<String>();
        set.add("rule3");
        StatefulSession session = this.getWorkingMemory("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        session.fireAllRules(ls.getAgendaFilter(set, false));
        TestingEventListenerTest.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        TestingEventListenerTest.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        TestingEventListenerTest.assertFalse((boolean)ls.firingCounts.containsKey("rule3"));
        TestingEventListenerTest.assertFalse((boolean)ls.firingCounts.containsKey("rule4"));
    }

    public void testNoFilter() throws Exception {
        HashSet set = new HashSet();
        StatefulSession session = this.getWorkingMemory("test_rules.drl");
        TestingEventListener ls = new TestingEventListener();
        session.addEventListener((AgendaEventListener)ls);
        session.insert((Object)new Cheese());
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.fireAllRules(ls.getAgendaFilter(set, false));
        TestingEventListenerTest.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule1")));
        TestingEventListenerTest.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule2")));
        TestingEventListenerTest.assertEquals((Object)new Integer(1), (Object)((Integer)ls.firingCounts.get("rule3")));
        String[] summary = ls.getRulesFiredSummary();
        TestingEventListenerTest.assertEquals((int)3, (int)summary.length);
        TestingEventListenerTest.assertNotNull((Object)summary[0]);
        TestingEventListenerTest.assertFalse((boolean)summary[1].equals(""));
        TestingEventListenerTest.assertEquals((int)1, (int)list.size());
    }
}

