/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.dt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldList;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateModel
extends RuleModel
implements PortableObject {
    public static final String ID_COLUMN_NAME = "__ID_KOL_NAME__";
    private long idCol = 0L;
    private Map<String, List<String>> table = new HashMap<String, List<String>>();
    private int rowsCount = 0;

    public int getColsCount() {
        return this.getInterpolationVariables().size() - 1;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    private String getNewIdColValue() {
        ++this.idCol;
        return String.valueOf(this.idCol);
    }

    public String addRow(String[] row) {
        return this.addRow(null, row);
    }

    public String addRow(String rowId, String[] row) {
        Map<String, Integer> vars = this.getInterpolationVariables();
        if (row.length != vars.size() - 1) {
            throw new IllegalArgumentException("Invalid numbers of columns: " + row.length + " expected: " + vars.size());
        }
        if (rowId == null || rowId.length() == 0) {
            rowId = this.getNewIdColValue();
        }
        for (Map.Entry<String, Integer> entry : vars.entrySet()) {
            List<String> list = this.table.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<String>();
                this.table.put(entry.getKey(), list);
            }
            if (this.rowsCount != list.size()) {
                throw new IllegalArgumentException("invalid list size for " + entry.getKey() + ", expected: " + this.rowsCount + " was: " + list.size());
            }
            if (ID_COLUMN_NAME.equals(entry.getKey())) {
                list.add(rowId);
                continue;
            }
            list.add(row[entry.getValue()]);
        }
        ++this.rowsCount;
        return rowId;
    }

    public boolean removeRowById(String rowId) {
        int idx = this.table.get(ID_COLUMN_NAME).indexOf(rowId);
        if (idx != -1) {
            for (List<String> col : this.table.values()) {
                col.remove(idx);
            }
            --this.rowsCount;
        }
        return idx != -1;
    }

    public void removeRow(int row) {
        if (row >= 0 && row < this.rowsCount) {
            for (List<String> col : this.table.values()) {
                col.remove(row);
            }
            --this.rowsCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(row);
        }
    }

    public void clearRows() {
        if (this.rowsCount > 0) {
            for (List<String> col : this.table.values()) {
                col.clear();
            }
            this.rowsCount = 0;
        }
    }

    public void putInSync() {
        Map<String, Integer> vars = this.getInterpolationVariables();
        this.table.keySet().retainAll(vars.keySet());
        vars.keySet().removeAll(this.table.keySet());
        ArrayList<String> aux = new ArrayList<String>(this.rowsCount);
        for (int i = 0; i < this.rowsCount; ++i) {
            aux.add("");
        }
        for (String varName : vars.keySet()) {
            this.table.put(varName, new ArrayList(aux));
        }
    }

    public String[] getInterpolationVariablesList() {
        Map<String, Integer> vars = this.getInterpolationVariables();
        String[] ret = new String[vars.size() - 1];
        for (Map.Entry<String, Integer> entry : vars.entrySet()) {
            if (ID_COLUMN_NAME.equals(entry.getKey())) continue;
            ret[entry.getValue().intValue()] = entry.getKey();
        }
        return ret;
    }

    private Map<String, Integer> getInterpolationVariables() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        new RuleModelVisitor(result).visit(this);
        result.put(ID_COLUMN_NAME, result.size());
        return result;
    }

    public Map<String, List<String>> getTable() {
        return this.table;
    }

    public String[][] getTableAsArray() {
        if (this.rowsCount <= 0) {
            return new String[0][0];
        }
        String[][] ret = new String[this.rowsCount][this.table.size() - 1];
        Map<String, Integer> vars = this.getInterpolationVariables();
        for (Map.Entry<String, Integer> entry : vars.entrySet()) {
            String varName = entry.getKey();
            if (ID_COLUMN_NAME.equals(entry.getKey())) continue;
            int idx = entry.getValue();
            for (int row = 0; row < this.rowsCount; ++row) {
                ret[row][idx] = this.table.get(varName).get(row);
            }
        }
        return ret;
    }

    public void setValue(String varName, int rowIndex, String newValue) {
        this.getTable().get(varName).set(rowIndex, newValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuleModelVisitor {
        private Map<String, Integer> vars;

        public RuleModelVisitor(Map<String, Integer> vars) {
            this.vars = vars;
        }

        public void visit(Object o) {
            if (o == null) {
                return;
            }
            if (o instanceof RuleModel) {
                this.visitRuleModel((RuleModel)o);
            } else if (o instanceof FactPattern) {
                this.visitFactPattern((FactPattern)o);
            } else if (o instanceof CompositeFieldConstraint) {
                this.visitCompositeFieldConstraint((CompositeFieldConstraint)o);
            } else if (o instanceof SingleFieldConstraint) {
                this.visitSingleFieldConstraint((SingleFieldConstraint)o);
            } else if (o instanceof CompositeFactPattern) {
                this.visitCompositeFactPattern((CompositeFactPattern)o);
            } else if (o instanceof FreeFormLine) {
                this.visitFreeFormLine((FreeFormLine)o);
            } else if (o instanceof FromAccumulateCompositeFactPattern) {
                this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)o);
            } else if (o instanceof FromCollectCompositeFactPattern) {
                this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)o);
            } else if (o instanceof FromCompositeFactPattern) {
                this.visitFromCompositeFactPattern((FromCompositeFactPattern)o);
            } else if (o instanceof DSLSentence) {
                this.visitDSLSentence((DSLSentence)o);
            } else if (o instanceof ActionFieldList) {
                this.visitActionFieldList((ActionFieldList)o);
            }
        }

        private void visitActionFieldList(ActionFieldList afl) {
            for (ActionFieldValue afv : afl.fieldValues) {
                if (afv.nature != 7L || this.vars.containsKey(afv.value)) continue;
                this.vars.put(afv.value, this.vars.size());
            }
        }

        public void visitRuleModel(RuleModel model) {
            if (model.lhs != null) {
                for (PortableObject portableObject : model.lhs) {
                    this.visit(portableObject);
                }
            }
            if (model.rhs != null) {
                for (PortableObject portableObject : model.rhs) {
                    this.visit(portableObject);
                }
            }
        }

        private void visitFactPattern(FactPattern pattern) {
            for (FieldConstraint fc : pattern.getFieldConstraints()) {
                this.visit(fc);
            }
        }

        private void visitCompositeFieldConstraint(CompositeFieldConstraint cfc) {
            if (cfc.constraints != null) {
                for (FieldConstraint fc : cfc.constraints) {
                    this.visit(fc);
                }
            }
        }

        private void visitSingleFieldConstraint(SingleFieldConstraint sfc) {
            if (7 == sfc.getConstraintValueType() && !this.vars.containsKey(sfc.getValue())) {
                this.vars.put(sfc.getValue(), this.vars.size());
            }
        }

        private void visitFreeFormLine(FreeFormLine ffl) {
            this.parseStringPattern(ffl.text);
        }

        private void visitCompositeFactPattern(CompositeFactPattern pattern) {
            if (pattern.patterns != null) {
                for (FactPattern fp : pattern.patterns) {
                    this.visit(fp);
                }
            }
        }

        private void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
            this.visit(pattern.getFactPattern());
            this.parseStringPattern(pattern.getExpression().getText());
        }

        private void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
            this.visit(pattern.getFactPattern());
            this.visit(pattern.getRightPattern());
        }

        private void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
            this.visit(pattern.getFactPattern());
            this.visit(pattern.getSourcePattern());
            this.parseStringPattern(pattern.getActionCode());
            this.parseStringPattern(pattern.getInitCode());
            this.parseStringPattern(pattern.getReverseCode());
        }

        private void visitDSLSentence(DSLSentence sentence) {
            this.parseStringPattern(sentence.sentence);
        }

        private void parseStringPattern(String text) {
            if (text == null || text.length() == 0) {
                return;
            }
            int pos = 0;
            while ((pos = text.indexOf("@{", pos)) != -1) {
                int end = text.indexOf(125, pos + 2);
                if (end == -1) continue;
                String var = text.substring(pos + 2, end);
                pos = end + 1;
                if (this.vars.containsKey(var)) continue;
                this.vars.put(var, this.vars.size());
            }
        }
    }
}

