/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jboss.integration;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.jboss.integration.FullDistributionTest;
import org.drools.workbench.models.commons.shared.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.commons.shared.oracle.model.Annotation;
import org.drools.workbench.models.commons.shared.oracle.model.ModelField;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.screens.datamodeller.model.AnnotationDefinitionTO;
import org.kie.workbench.common.screens.datamodeller.model.DataModelTO;
import org.kie.workbench.common.screens.datamodeller.model.DataObjectTO;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.model.ObjectPropertyTO;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;

@Ignore
@RunWith(value=Arquillian.class)
public class AnnotationsTest
extends FullDistributionTest {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationsTest.class);
    @Inject
    IOService ioService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private DataModelerService modelerService;
    @Inject
    private ProjectService projectService;
    @Inject
    private Paths paths;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCache;

    @Test
    public void testLoadModelWithAnnotatedNonModellerPojos() {
        try {
            TestCase.assertNotNull((Object)this.ioService);
            TestCase.assertNotNull((Object)this.dataModelService);
            TestCase.assertNotNull((Object)this.paths);
            URI projectUri = null;
            projectUri = new URI("default://master@uf-playground/GuvnorM2RepoDependencyExample1");
            Path projectPath = this.ioService.get(projectUri);
            TestCase.assertNotNull((Object)projectPath);
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(this.paths.convert(projectPath)));
            ProjectDataModelOracle projectDataModelOracle = this.dataModelService.getProjectDataModel(this.paths.convert(projectPath));
            String annotationTest = "org.kie.test.AnnotationsBean";
            String annotationTestSerializable = "org.kie.test.AnnotationsBeanSerializable";
            boolean isTestLoaded = false;
            boolean isTestSerializableLoaded = false;
            String[] types = projectDataModelOracle.getFactTypes();
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    logger.info("**************************** -> Loading type: " + types[i]);
                    if (annotationTest.equals(types[i])) {
                        isTestLoaded = true;
                    }
                    if (!annotationTestSerializable.equals(types[i])) continue;
                    isTestSerializableLoaded = true;
                }
            } else {
                logger.info("project has no types");
            }
            TestCase.assertEquals((String)("Annotations test class: " + annotationTest + " wasn't loaded"), (boolean)true, (boolean)isTestLoaded);
            TestCase.assertEquals((String)("Annotations test class: " + annotationTestSerializable + " wasn't loaded"), (boolean)true, (boolean)isTestSerializableLoaded);
        }
        catch (Exception e) {
            logger.error("Test failed : " + e.getMessage(), (Throwable)e);
            Assert.fail();
        }
    }

    @Test
    public void testLoadModelWithAnnotatedModelledPojos() {
        try {
            TestCase.assertNotNull((Object)this.ioService);
            TestCase.assertNotNull((Object)this.dataModelService);
            TestCase.assertNotNull((Object)this.paths);
            TestCase.assertNotNull((Object)this.modelerService);
            TestCase.assertNotNull((Object)this.projectService);
            URI projectUri = new URI("default://master@uf-playground/GuvnorM2RepoDependencyExample2");
            Path projectPath = this.ioService.get(projectUri);
            TestCase.assertNotNull((Object)projectPath);
            org.uberfire.backend.vfs.Path path = this.paths.convert(projectPath);
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            Project project = this.projectService.resolveProject(path);
            Map annotationDefs = this.modelerService.getAnnotationDefinitions();
            DataModelTO dataModel = this.modelerService.loadModel(project);
            String objectName = "GeneratedBean";
            String objectPackage = "a.b.c";
            String objectLabelValue = "Generated Bean";
            String objectDescriptionValue = "This is a programmatically added bean";
            String objectRoleValue = "EVENT";
            DataObjectTO dataObject = new DataObjectTO(objectName, objectPackage, null);
            dataObject.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Label"), "value", (Object)objectLabelValue);
            dataObject.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Description"), "value", (Object)objectDescriptionValue);
            dataObject.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.api.definition.type.Role"), "value", (Object)objectRoleValue);
            dataModel.getDataObjects().add(dataObject);
            String fieldName = "simpleProperty";
            String fieldClass = "java.lang.String";
            String fieldLabelValue = "Simple Property";
            String fieldDescriptionValue = "This is a programmatically added String property";
            int fieldPositionValue = 1;
            ObjectPropertyTO baseTypeProp = new ObjectPropertyTO(fieldName, fieldClass, false, true);
            baseTypeProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Label"), "value", (Object)fieldLabelValue);
            baseTypeProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Description"), "value", (Object)fieldDescriptionValue);
            baseTypeProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.api.definition.type.Position"), "value", (Object)fieldPositionValue);
            dataObject.setProperties(Arrays.asList(baseTypeProp));
            GenerationResult result = this.modelerService.saveModel(dataModel, project);
            TestCase.assertNotNull((Object)result);
            logger.info("**************************** -> Model saved in " + result.getGenerationTimeSeconds() + " seconds");
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            DataModelTO reloadedModel = this.modelerService.loadModel(project);
            TestCase.assertNotNull((Object)reloadedModel);
            ProjectDataModelOracle projectDataModelOracle = this.dataModelService.getProjectDataModel(path);
            String[] types = projectDataModelOracle.getFactTypes();
            if (types != null) {
                for (String type : types) {
                    if (!(objectPackage + "." + objectName).equals(type)) continue;
                    Set annotations = projectDataModelOracle.getTypeAnnotations(type);
                    TestCase.assertNotNull((Object)annotations);
                    TestCase.assertEquals((String)("Type " + type + " should hold 3 annotations: "), (int)3, (int)annotations.size());
                    this.checkAnnotation(annotations, "org.kie.workbench.common.services.datamodeller.annotations.Label", objectLabelValue);
                    this.checkAnnotation(annotations, "org.kie.workbench.common.services.datamodeller.annotations.Description", objectDescriptionValue);
                    this.checkAnnotation(annotations, "org.kie.api.definition.type.Role", objectRoleValue);
                    ModelField[] fields = (ModelField[])projectDataModelOracle.getModelFields().get(type);
                    TestCase.assertNotNull((Object)fields);
                    TestCase.assertEquals((String)("Error in type " + type + "'s fields: "), (int)2, (int)fields.length);
                    Map mFieldAnnotations = projectDataModelOracle.getTypeFieldsAnnotations(type);
                    TestCase.assertNotNull((Object)mFieldAnnotations);
                    Set fieldAnnotations = (Set)mFieldAnnotations.get(fieldName);
                    TestCase.assertNotNull((Object)fieldAnnotations);
                    TestCase.assertEquals((String)("Field " + fieldName + "should have 3 annotations: "), (int)3, (int)fieldAnnotations.size());
                    this.checkAnnotation(fieldAnnotations, "org.kie.workbench.common.services.datamodeller.annotations.Label", fieldLabelValue);
                    this.checkAnnotation(fieldAnnotations, "org.kie.workbench.common.services.datamodeller.annotations.Description", fieldDescriptionValue);
                    this.checkAnnotation(fieldAnnotations, "org.kie.api.definition.type.Position", Integer.toString(fieldPositionValue));
                }
            } else {
                logger.error("Test failed: error in fact types");
                Assert.fail();
            }
        }
        catch (Throwable e) {
            logger.error("Test failed : " + e.getMessage(), e);
            Assert.fail();
        }
    }

    @Test
    public void testLoadModelledPojoExtension() {
        try {
            TestCase.assertNotNull((Object)this.ioService);
            TestCase.assertNotNull((Object)this.dataModelService);
            TestCase.assertNotNull((Object)this.paths);
            TestCase.assertNotNull((Object)this.modelerService);
            TestCase.assertNotNull((Object)this.projectService);
            URI projectUri = new URI("default://master@uf-playground/GuvnorM2RepoDependencyExample2");
            Path projectPath = this.ioService.get(projectUri);
            TestCase.assertNotNull((Object)projectPath);
            org.uberfire.backend.vfs.Path path = this.paths.convert(projectPath);
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            Project project = this.projectService.resolveProject(path);
            Map annotationDefs = this.modelerService.getAnnotationDefinitions();
            DataModelTO dataModel = this.modelerService.loadModel(project);
            String parentName = "A";
            String parentPackage = "a";
            DataObjectTO parent = new DataObjectTO(parentName, parentPackage, null);
            dataModel.getDataObjects().add(parent);
            String parentFieldName = "a_1";
            String parentFieldClass = "java.lang.String";
            ObjectPropertyTO parentProp = new ObjectPropertyTO(parentFieldName, parentFieldClass, false, true);
            parent.setProperties(Arrays.asList(parentProp));
            String extendingName = "B";
            String extendingPackage = "a.b";
            DataObjectTO extending = new DataObjectTO(extendingName, extendingPackage, null);
            extending.setSuperClassName(parent.getClassName());
            dataModel.getDataObjects().add(extending);
            String extendingFieldName = "b_1";
            String extendingFieldClass = "java.lang.String";
            ObjectPropertyTO extendingProp = new ObjectPropertyTO(extendingFieldName, extendingFieldClass, false, true);
            extending.setProperties(Arrays.asList(extendingProp));
            GenerationResult result = this.modelerService.saveModel(dataModel, project);
            TestCase.assertNotNull((Object)result);
            logger.info("**************************** -> Model saved in " + result.getGenerationTimeSeconds() + " seconds");
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            DataModelTO reloadedModel = this.modelerService.loadModel(project);
            TestCase.assertNotNull((Object)reloadedModel);
        }
        catch (Throwable e) {
            logger.error("Test failed : " + e.getMessage(), e);
            Assert.fail();
        }
    }

    @Test
    public void testLoadModelledAnnotatedPojoExtension() {
        try {
            TestCase.assertNotNull((Object)this.ioService);
            TestCase.assertNotNull((Object)this.dataModelService);
            TestCase.assertNotNull((Object)this.paths);
            TestCase.assertNotNull((Object)this.modelerService);
            TestCase.assertNotNull((Object)this.projectService);
            URI projectUri = new URI("default://master@uf-playground/GuvnorM2RepoDependencyExample2");
            Path projectPath = this.ioService.get(projectUri);
            TestCase.assertNotNull((Object)projectPath);
            org.uberfire.backend.vfs.Path path = this.paths.convert(projectPath);
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            Project project = this.projectService.resolveProject(path);
            Map annotationDefs = this.modelerService.getAnnotationDefinitions();
            DataModelTO dataModel = this.modelerService.loadModel(project);
            String parentName = "A2";
            String parentPackage = "a";
            String parentLabelValue = "Parent";
            String parentDescriptionValue = "This is the parent object";
            String parentRoleValue = "EVENT";
            DataObjectTO parent = new DataObjectTO(parentName, parentPackage, null);
            parent.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Label"), "value", (Object)parentLabelValue);
            parent.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Description"), "value", (Object)parentDescriptionValue);
            parent.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.api.definition.type.Role"), "value", (Object)parentRoleValue);
            dataModel.getDataObjects().add(parent);
            String parentFieldName = "a2_1";
            String parentFieldClass = "java.lang.String";
            String parentFieldLabelValue = "Attribute A2.1";
            String parentFieldDescriptionValue = "First attribute of A2";
            int parentFieldPositionValue = 1;
            ObjectPropertyTO parentProp = new ObjectPropertyTO(parentFieldName, parentFieldClass, false, true);
            parentProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Label"), "value", (Object)parentFieldLabelValue);
            parentProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Description"), "value", (Object)parentFieldDescriptionValue);
            parentProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.api.definition.type.Position"), "value", (Object)parentFieldPositionValue);
            parent.setProperties(Arrays.asList(parentProp));
            String extendingName = "B2";
            String extendingPackage = "a.b";
            String extendingLabelValue = "Extending";
            String extendingDescriptionValue = "This is the extending object";
            String extendingRoleValue = "EVENT";
            DataObjectTO extending = new DataObjectTO(extendingName, extendingPackage, null);
            extending.setSuperClassName(parent.getClassName());
            extending.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Label"), "value", (Object)extendingLabelValue);
            extending.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Description"), "value", (Object)extendingDescriptionValue);
            extending.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.api.definition.type.Role"), "value", (Object)extendingRoleValue);
            dataModel.getDataObjects().add(extending);
            String extendingFieldName = "b2_1";
            String extendingFieldClass = "java.lang.String";
            String extendingFieldLabelValue = "Attribute B2.1";
            String extendingFieldDescriptionValue = "First attribute of B2";
            int extendingFieldPositionValue = 1;
            ObjectPropertyTO extendingProp = new ObjectPropertyTO(extendingFieldName, extendingFieldClass, false, true);
            extendingProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Label"), "value", (Object)extendingFieldLabelValue);
            extendingProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.workbench.common.services.datamodeller.annotations.Description"), "value", (Object)extendingFieldDescriptionValue);
            extendingProp.addAnnotation((AnnotationDefinitionTO)annotationDefs.get("org.kie.api.definition.type.Position"), "value", (Object)extendingFieldPositionValue);
            extending.setProperties(Arrays.asList(extendingProp));
            GenerationResult result = this.modelerService.saveModel(dataModel, project);
            TestCase.assertNotNull((Object)result);
            logger.info("**************************** -> Model saved in " + result.getGenerationTimeSeconds() + " seconds");
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            DataModelTO reloadedModel = this.modelerService.loadModel(project);
            TestCase.assertNotNull((Object)reloadedModel);
        }
        catch (Throwable e) {
            logger.error("Test failed : " + e.getMessage(), e);
            Assert.fail();
        }
    }

    @Test
    public void testPojoExtensionAttributes() {
        try {
            TestCase.assertNotNull((Object)this.ioService);
            TestCase.assertNotNull((Object)this.dataModelService);
            TestCase.assertNotNull((Object)this.paths);
            TestCase.assertNotNull((Object)this.modelerService);
            TestCase.assertNotNull((Object)this.projectService);
            URI projectUri = new URI("default://master@uf-playground/GuvnorM2RepoDependencyExample2");
            Path projectPath = this.ioService.get(projectUri);
            TestCase.assertNotNull((Object)projectPath);
            org.uberfire.backend.vfs.Path path = this.paths.convert(projectPath);
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            Project project = this.projectService.resolveProject(path);
            Map annotationDefs = this.modelerService.getAnnotationDefinitions();
            DataModelTO dataModel = this.modelerService.loadModel(project);
            String parentName = "A3";
            String parentPackage = "a";
            DataObjectTO parent = new DataObjectTO(parentName, parentPackage, null);
            dataModel.getDataObjects().add(parent);
            String parentFieldName = "a3_1";
            String parentFieldClass = "java.lang.String";
            ObjectPropertyTO parentProp = new ObjectPropertyTO(parentFieldName, parentFieldClass, false, true);
            parent.setProperties(Arrays.asList(parentProp));
            String extendingName = "B3";
            String extendingPackage = "a.b";
            DataObjectTO extending = new DataObjectTO(extendingName, extendingPackage, null);
            extending.setSuperClassName(parent.getClassName());
            dataModel.getDataObjects().add(extending);
            String extendingFieldName = "b3_1";
            String extendingFieldClass = "java.lang.String";
            ObjectPropertyTO extendingProp = new ObjectPropertyTO(extendingFieldName, extendingFieldClass, false, true);
            extending.setProperties(Arrays.asList(extendingProp));
            GenerationResult result = this.modelerService.saveModel(dataModel, project);
            TestCase.assertNotNull((Object)result);
            logger.info("**************************** -> Model saved in " + result.getGenerationTimeSeconds() + " seconds");
            this.invalidateDMOProjectCache.fire((Object)new InvalidateDMOProjectCacheEvent(path));
            DataModelTO reloadedModel = this.modelerService.loadModel(project);
            TestCase.assertNotNull((Object)reloadedModel);
            ProjectDataModelOracle projectDataModelOracle = this.dataModelService.getProjectDataModel(path);
            Map modelFields = projectDataModelOracle.getModelFields();
            if (modelFields != null) {
                String inheritorFullName = extendingPackage + "." + extendingName;
                ModelField[] fields = (ModelField[])modelFields.get(inheritorFullName);
                TestCase.assertNotNull((Object)fields);
                TestCase.assertEquals((String)("Error in type " + inheritorFullName + "'s fields: "), (int)2, (int)fields.length);
                for (int i = 0; i < fields.length; ++i) {
                    String fieldName = fields[i].getName();
                    if (!parentFieldName.equals(fieldName)) continue;
                    Assert.fail((String)("Encountered the parent attribute " + parentFieldName));
                }
            } else {
                logger.error("Test failed: error in model fields");
                Assert.fail();
            }
        }
        catch (Throwable e) {
            logger.error("Test failed : " + e.getMessage(), e);
            Assert.fail();
        }
    }

    private void checkAnnotation(Set<Annotation> annotations, String expectedType, String expectedValue) {
        boolean expectedTypeFound;
        if (annotations != null && expectedType != null && expectedValue != null) {
            expectedTypeFound = false;
            for (Annotation a : annotations) {
                if (!expectedType.equals(a.getQualifiedTypeName())) continue;
                expectedTypeFound = true;
                Map attribs = a.getAttributes();
                if (attribs != null && attribs.size() == 1) {
                    String value = (String)attribs.get("value");
                    if (value != null && expectedValue.equals(value)) continue;
                    Assert.fail((String)(expectedType + "annotation's value mismatch"));
                    continue;
                }
                Assert.fail((String)("Wrong attributes for Annotation " + expectedType));
            }
        } else {
            throw new IllegalArgumentException();
        }
        TestCase.assertEquals((String)("The Annotation of type" + expectedType + " was not present"), (boolean)true, (boolean)expectedTypeFound);
    }
}

