/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlConnection
extends ConnectionImpl {
    private static final long serialVersionUID = 1L;
    protected String condition;
    private Map<String, Event> events;
    private List<ExceptionHandler> exceptionHandlers;

    public JpdlConnection(Node from, String fromType, Node to, String toType) {
        super((org.drools.definition.process.Node)from, fromType, (org.drools.definition.process.Node)to, toType);
    }

    public Map<String, Event> getEvents() {
        return this.events;
    }

    public boolean hasEvents() {
        return this.events != null && this.events.size() > 0;
    }

    public Event getEvent(String eventType) {
        Event event = null;
        if (this.events != null) {
            event = this.events.get(eventType);
        }
        return event;
    }

    public boolean hasEvent(String eventType) {
        boolean hasEvent = false;
        if (this.events != null) {
            hasEvent = this.events.containsKey(eventType);
        }
        return hasEvent;
    }

    public Event addEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("can't add a null event to a graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't add an event without an eventType to a graph element");
        }
        if (this.events == null) {
            this.events = new HashMap<String, Event>();
        }
        this.events.put(event.getEventType(), event);
        return event;
    }

    public Event removeEvent(Event event) {
        Event removedEvent = null;
        if (event == null) {
            throw new IllegalArgumentException("can't remove a null event from a graph element");
        }
        if (event.getEventType() == null) {
            throw new IllegalArgumentException("can't remove an event without an eventType from a graph element");
        }
        if (this.events != null) {
            removedEvent = this.events.remove(event.getEventType());
        }
        return removedEvent;
    }

    public List getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public ExceptionHandler addExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't add a null exceptionHandler to a connection");
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new ArrayList<ExceptionHandler>();
        }
        this.exceptionHandlers.add(exceptionHandler);
        return exceptionHandler;
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("can't remove a null exceptionHandler from a connection");
        }
        if (this.exceptionHandlers != null) {
            this.exceptionHandlers.remove(exceptionHandler);
        }
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }
}

