/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.instance.node;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.jpdl.core.JpdlConnection;
import org.drools.jpdl.core.node.JpdlNode;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.context.exception.ExceptionScopeInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.instance.timer.TimerInstance;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.workflow.instance.NodeInstanceContainer;
import org.drools.workflow.instance.impl.NodeInstanceImpl;
import org.drools.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.JbpmException;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.scheduler.def.CancelTimerAction;
import org.jbpm.scheduler.def.CreateTimerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlNodeInstance
extends NodeInstanceImpl
implements EventBasedNodeInstanceInterface,
EventListener {
    private static final long serialVersionUID = 1L;
    private static final BusinessCalendar BUSINESS_CALENDAR = new BusinessCalendar();
    private Map<Long, Action> timerActions = new HashMap<Long, Action>();
    private Map<String, List<TimerInstance>> timers = new HashMap<String, List<TimerInstance>>();

    public JpdlNode getJpdlNode() {
        return (JpdlNode)this.getNode();
    }

    private Action getAction() {
        return this.getJpdlNode().getAction();
    }

    public void internalTrigger(NodeInstance from, String type) {
        this.fireEvent("node-enter");
        this.execute(from, type);
    }

    public void execute(NodeInstance from, String type) {
        Action action = this.getAction();
        if (action != null) {
            try {
                action.execute((ExecutionContext)new JpdlExecutionContext());
            }
            catch (Exception exception) {
                this.raiseException(exception);
            }
        } else {
            this.leave();
        }
    }

    public void leave() {
        if (this.getNode().getOutgoingConnections("DROOLS_DEFAULT") != null) {
            this.leave("DROOLS_DEFAULT");
        } else if (this.getNode().getOutgoingConnections().size() == 1) {
            String type = (String)this.getNode().getOutgoingConnections().keySet().iterator().next();
            this.leave(type);
        } else {
            throw new IllegalArgumentException("Could not find default leave transition: " + (Object)((Object)this));
        }
    }

    public void leave(String type) {
        String condition;
        List actions;
        JpdlConnection connection = (JpdlConnection)this.getJpdlNode().getOutgoingConnection(type);
        if (connection == null) {
            throw new JbpmException("transition '" + type + "' is not a leaving transition of node '" + (Object)((Object)this) + "'");
        }
        this.removeEventListeners();
        this.fireEvent("node-leave");
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance((org.drools.workflow.instance.NodeInstance)this);
        Event event = connection.getEvent("transition");
        if (event != null && (actions = event.getActions()) != null) {
            for (Action action : actions) {
                try {
                    action.execute((ExecutionContext)new JpdlExecutionContext());
                }
                catch (Exception exception) {
                    boolean handled = false;
                    List exceptionHandlers = connection.getExceptionHandlers();
                    try {
                        for (ExceptionHandler exceptionHandler : exceptionHandlers) {
                            if (!exceptionHandler.matches((Throwable)exception)) continue;
                            exceptionHandler.handleException(null, (ExecutionContext)new JpdlExecutionContext());
                            handled = true;
                        }
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    if (handled) continue;
                    if (exception instanceof JbpmException) {
                        throw (JbpmException)exception;
                    }
                    throw new DelegationException((Throwable)exception, null);
                }
            }
        }
        if ((condition = connection.getCondition()) != null) {
            Object result = JbpmExpressionEvaluator.evaluate((String)condition, (ExecutionContext)new JpdlExecutionContext());
            if (result == null) {
                throw new JbpmException("connection condition " + condition + " evaluated to null");
            }
            if (!(result instanceof Boolean)) {
                throw new JbpmException("connection condition " + condition + " evaluated to non-boolean: " + result.getClass().getName());
            }
            if (!((Boolean)result).booleanValue()) {
                throw new JbpmException("connection condition " + condition + " evaluated to 'false'");
            }
        }
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstance(connection.getTo()).trigger((NodeInstance)this, connection.getToType());
    }

    public void fireEvent(String eventType) {
        this.fireEvent(eventType, new JpdlExecutionContext());
    }

    public void fireEvent(String eventType, ExecutionContext executionContext) {
        Event event = this.getJpdlNode().getEvent(eventType);
        if (event != null) {
            this.executeActions(event.getActions(), executionContext);
        }
    }

    public void executeActions(List<Action> actions, ExecutionContext executionContext) {
        if (actions != null) {
            for (Action action : actions) {
                this.executeAction(action, executionContext);
            }
        }
    }

    public void executeAction(Action action, ExecutionContext executionContext) {
        if (action instanceof CreateTimerAction) {
            CreateTimerAction createTimerAction = (CreateTimerAction)action;
            String timerName = createTimerAction.getTimerName();
            TimerInstance timer = new TimerInstance();
            long delay = BUSINESS_CALENDAR.add(new Date(0L), new Duration(createTimerAction.getDueDate())).getTime();
            timer.setDelay(delay);
            if (createTimerAction.getRepeat() != null) {
                long period = BUSINESS_CALENDAR.add(new Date(0L), new Duration(createTimerAction.getRepeat())).getTime();
                timer.setPeriod(period);
            }
            if (this.timerActions.isEmpty()) {
                this.addTimerListener();
            }
            this.getProcessInstance().getWorkingMemory().getTimerManager().registerTimer(timer, (ProcessInstance)this.getProcessInstance());
            this.timerActions.put(timer.getId(), createTimerAction.getTimerAction());
            List<TimerInstance> timerList = this.timers.get(timerName);
            if (timerList == null) {
                timerList = new ArrayList<TimerInstance>();
                this.timers.put(timerName, timerList);
            }
            timerList.add(timer);
        } else if (action instanceof CancelTimerAction) {
            String timerName = ((CancelTimerAction)action).getTimerName();
            List<TimerInstance> timerList = this.timers.get(timerName);
            if (timerList != null) {
                for (TimerInstance timer : timerList) {
                    this.timerActions.remove(timer.getId());
                    this.getProcessInstance().getWorkingMemory().getTimerManager().cancelTimer(timer.getId());
                }
                this.timers.remove(timerName);
                if (this.timerActions.isEmpty()) {
                    this.removeTimerListener();
                }
            }
        } else {
            try {
                action.execute(executionContext);
            }
            catch (Exception exception) {
                this.raiseException(exception);
            }
        }
    }

    public void raiseException(Throwable exception) throws DelegationException {
        for (Class<?> clazz = exception.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", clazz.getName());
            if (exceptionScopeInstance == null) continue;
            exceptionScopeInstance.handleException(clazz.getName(), (Object)exception);
            return;
        }
        if (exception instanceof JbpmException) {
            throw (JbpmException)exception;
        }
        throw new DelegationException(exception, null);
    }

    public String[] getEventTypes() {
        return new String[]{"timerTriggered"};
    }

    public void signalEvent(String type, Object event) {
        TimerInstance timer;
        Action action;
        if ("timerTriggered".equals(type) && (action = this.timerActions.get((timer = (TimerInstance)event).getId())) != null) {
            this.executeAction(action, new JpdlExecutionContext());
        }
    }

    public void addEventListeners() {
        if (this.timers.size() > 0) {
            this.addTimerListener();
        }
    }

    public void addTimerListener() {
        this.getProcessInstance().addEventListener("timerTriggered", (EventListener)this, false);
    }

    public void removeEventListeners() {
        if (this.timers.size() > 0) {
            this.removeTimerListener();
        }
    }

    public void removeTimerListener() {
        this.getProcessInstance().removeEventListener("timerTriggered", (EventListener)this, false);
    }

    public class JpdlExecutionContext
    extends ExecutionContext {
        public JpdlExecutionContext(NodeInstance node) {
            super((Token)new JpdlToken(node));
        }

        public JpdlExecutionContext() {
            super((Token)null);
        }

        public void leaveNode() {
            JpdlNodeInstance.this.leave();
        }

        public void leaveNode(String transitionName) {
            JpdlNodeInstance.this.leave(transitionName);
        }

        public void leaveNode(Transition transition) {
            this.leaveNode(transition.getName());
        }

        public void setVariable(String name, Object value) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)JpdlNodeInstance.this.resolveContextInstance("VariableScope", name);
            variableScopeInstance.setVariable(name, value);
        }

        public Object getVariable(String name) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)JpdlNodeInstance.this.resolveContextInstance("VariableScope", name);
            if (variableScopeInstance == null) {
                variableScopeInstance = (VariableScopeInstance)JpdlNodeInstance.this.getProcessInstance().getContextInstance("VariableScope");
            }
            return variableScopeInstance.getVariable(name);
        }

        public ContextInstance getContextInstance() {
            ContextInstance contextInstance = new ContextInstance(){

                public Object getVariable(String name) {
                    return JpdlExecutionContext.this.getVariable(name);
                }
            };
            return contextInstance;
        }

        public ProcessInstance getDroolsProcessInstance() {
            return JpdlNodeInstance.this.getProcessInstance();
        }

        public NodeInstance getDroolsNodeInstance() {
            return JpdlNodeInstance.this;
        }

        public ProcessDefinition getProcessDefinition() {
            return null;
        }
    }

    public class JpdlToken
    extends Token {
        public JpdlToken(NodeInstance node) {
            Node jBPMNode = new Node();
            jBPMNode.setName(node.getNodeName());
            this.setNode(jBPMNode);
        }
    }
}

