/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.instance.node;

import java.util.HashMap;
import java.util.Set;
import org.drools.WorkingMemory;
import org.drools.event.RuleFlowCompletedEvent;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.RuleFlowNodeTriggeredEvent;
import org.drools.event.RuleFlowStartedEvent;
import org.drools.jpdl.core.node.ProcessState;
import org.drools.jpdl.instance.node.JpdlNodeInstance;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.workflow.instance.NodeInstance;
import org.jbpm.context.def.VariableAccess;

public class ProcessStateInstance
extends JpdlNodeInstance
implements RuleFlowEventListener {
    private static final long serialVersionUID = 1L;
    private long processInstanceId;

    public ProcessState getProcessState() {
        return (ProcessState)this.getNode();
    }

    public void execute(NodeInstance from, String type) {
        HashMap<String, Object> parameters = null;
        Set<VariableAccess> variableAccesses = this.getProcessState().getVariableAccesses();
        if (variableAccesses != null && !variableAccesses.isEmpty()) {
            parameters = new HashMap<String, Object>();
            for (VariableAccess variableAccess : variableAccesses) {
                String variableName;
                VariableScopeInstance variableScopeInstance;
                Object value;
                if (!variableAccess.isReadable() || (value = (variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName = variableAccess.getVariableName())).getVariable(variableName)) == null) continue;
                String mappedName = variableAccess.getMappedName();
                parameters.put(mappedName, value);
            }
        }
        this.addEventListeners();
        this.processInstanceId = this.getProcessInstance().getWorkingMemory().startProcess(this.getProcessState().getSubProcessName(), parameters).getId();
        this.fireEvent("subprocess-created");
    }

    public void addEventListeners() {
        this.getProcessInstance().getWorkingMemory().addEventListener((RuleFlowEventListener)this);
    }

    public void removeEventListeners() {
        this.getProcessInstance().getWorkingMemory().removeEventListener((RuleFlowEventListener)this);
    }

    public void afterRuleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
        if (event.getProcessInstance().getId() == this.processInstanceId) {
            this.removeEventListeners();
            Set<VariableAccess> variableAccesses = this.getProcessState().getVariableAccesses();
            if (variableAccesses != null && !variableAccesses.isEmpty()) {
                for (VariableAccess variableAccess : variableAccesses) {
                    if (!variableAccess.isWritable()) continue;
                    String mappedName = variableAccess.getMappedName();
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((ProcessInstance)event.getProcessInstance()).getContextInstance("VariableScope");
                    Object value = variableScopeInstance.getVariable(mappedName);
                    if (value == null) continue;
                    String variableName = variableAccess.getVariableName();
                    variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mappedName);
                    variableScopeInstance.setVariable(variableName, value);
                }
            }
            this.fireEvent("subprocess-end");
            this.leave();
        }
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
    }

    public void afterRuleFlowNodeTriggered(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
    }

    public void afterRuleFlowNodeLeft(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
    }

    public void afterRuleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
    }

    public void beforeRuleFlowCompleted(RuleFlowCompletedEvent event, WorkingMemory workingMemory) {
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
    }

    public void beforeRuleFlowNodeTriggered(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
    }

    public void beforeRuleFlowNodeLeft(RuleFlowNodeTriggeredEvent event, WorkingMemory workingMemory) {
    }

    public void beforeRuleFlowStarted(RuleFlowStartedEvent event, WorkingMemory workingMemory) {
    }
}

