/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.instance.node;

import org.drools.jpdl.core.node.StartState;
import org.drools.jpdl.instance.node.JpdlNodeInstance;
import org.drools.jpdl.instance.node.StateInstance;
import org.drools.jpdl.instance.node.TaskUtils;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.context.swimlane.SwimlaneContextInstance;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.taskmgmt.def.Task;

public class StartStateInstance
extends StateInstance {
    private static final long serialVersionUID = 1L;
    private long workItemId = -1L;
    private transient WorkItem workItem;

    public StartState getStartState() {
        return (StartState)this.getJpdlNode();
    }

    public void execute(NodeInstance from, String type) {
        super.execute(from, type);
        Task task = this.getStartState().getTask();
        if (task != null && this.evaluateTaskCondition(task.getCondition())) {
            this.addWorkItemListener();
            this.workItem = (WorkItemImpl)TaskUtils.createWorkItem(task, this);
            this.getProcessInstance().getWorkingMemory().getWorkItemManager().internalExecuteWorkItem(this.workItem);
        }
    }

    private boolean evaluateTaskCondition(String condition) {
        if (condition == null) {
            return true;
        }
        Object result = JbpmExpressionEvaluator.evaluate((String)condition, (ExecutionContext)new JpdlNodeInstance.JpdlExecutionContext());
        return Boolean.TRUE.equals(result);
    }

    public WorkItem getWorkItem() {
        if (this.workItem == null && this.workItemId >= 0L) {
            this.workItem = this.getProcessInstance().getWorkingMemory().getWorkItemManager().getWorkItem(this.workItemId);
        }
        return this.workItem;
    }

    public void addEventListeners() {
        super.addEventListeners();
        this.addWorkItemListener();
    }

    private void addWorkItemListener() {
        this.getProcessInstance().addEventListener("workItemCompleted", (EventListener)this, false);
        this.getProcessInstance().addEventListener("workItemAborted", (EventListener)this, false);
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("workItemCompleted", (EventListener)this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", (EventListener)this, false);
    }

    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((WorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((WorkItem)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    public void workItemAborted(WorkItem workItem) {
        if (this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.leave();
        }
    }

    public void workItemCompleted(WorkItem workItem) {
        if (this.getWorkItem().getId() == workItem.getId()) {
            String result;
            Event event;
            String actorId;
            String swimlaneName;
            SwimlaneContextInstance swimlaneContextInstance;
            this.removeEventListeners();
            Task task = this.getStartState().getTask();
            TaskUtils.restoreVariables((WorkItemImpl)workItem, task, this);
            if (task.getSwimlane() != null && (swimlaneContextInstance = (SwimlaneContextInstance)this.resolveContextInstance("SwimlaneScope", swimlaneName = task.getSwimlane().getName())).getActorId(swimlaneName) == null && (actorId = (String)workItem.getResult("ActorId")) != null) {
                swimlaneContextInstance.setActorId(swimlaneName, (String)workItem.getResult("ActorId"));
            }
            if ((event = task.getEvent("task-end")) != null) {
                JpdlNodeInstance.JpdlExecutionContext context = new JpdlNodeInstance.JpdlExecutionContext();
                context.setTask(task);
                this.executeActions(event.getActions(), context);
            }
            if ((result = (String)workItem.getResult("Result")) != null) {
                this.leave(result);
            } else {
                this.leave();
            }
        }
    }
}

