/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.instance.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.jpdl.core.node.TaskNode;
import org.drools.jpdl.instance.node.JpdlNodeInstance;
import org.drools.jpdl.instance.node.TaskUtils;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.context.swimlane.SwimlaneContextInstance;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.taskmgmt.def.Task;

public class TaskNodeInstance
extends JpdlNodeInstance {
    private static final long serialVersionUID = 1L;
    private List<WorkItemImpl> workItems = new ArrayList<WorkItemImpl>();

    public TaskNode getTaskNode() {
        return (TaskNode)this.getNode();
    }

    public void execute(NodeInstance from, String type) {
        Set<Task> tasks = this.getTaskNode().getTasks();
        if (this.getTaskNode().isCreateTasks() && tasks != null) {
            this.addEventListeners();
            for (Task task : tasks) {
                if (!this.evaluateTaskCondition(task.getCondition())) continue;
                WorkItemImpl workItem = (WorkItemImpl)TaskUtils.createWorkItem(task, this);
                this.workItems.add(workItem);
                this.getProcessInstance().getWorkingMemory().getWorkItemManager().internalExecuteWorkItem((WorkItem)workItem);
            }
        }
        boolean continueExecution = false;
        switch (this.getTaskNode().getSignal()) {
            case 0: {
                continueExecution = true;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                continueExecution = false;
                break;
            }
            case 2: 
            case 4: {
                boolean bl = continueExecution = !this.hasSignallingWorkItems();
            }
        }
        if (continueExecution) {
            this.leave();
        }
    }

    private boolean evaluateTaskCondition(String condition) {
        if (condition == null) {
            return true;
        }
        Object result = JbpmExpressionEvaluator.evaluate((String)condition, (ExecutionContext)new JpdlNodeInstance.JpdlExecutionContext(this));
        return Boolean.TRUE.equals(result);
    }

    private boolean hasSignallingWorkItems() {
        for (WorkItemImpl workItem : this.workItems) {
            if (!((Boolean)workItem.getParameter("signalling")).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean hasBlockingWorkItems() {
        for (WorkItemImpl workItem : this.workItems) {
            if (!((Boolean)workItem.getParameter("blocking")).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void addEventListeners() {
        this.getProcessInstance().addEventListener("workItemCompleted", (EventListener)this, false);
        this.getProcessInstance().addEventListener("workItemAborted", (EventListener)this, false);
    }

    public void removeEventListeners() {
        this.getProcessInstance().removeEventListener("workItemCompleted", (EventListener)this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", (EventListener)this, false);
    }

    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((org.drools.runtime.process.WorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((org.drools.runtime.process.WorkItem)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    public void workItemAborted(org.drools.runtime.process.WorkItem workItem) {
        if (this.workItems.remove(workItem) && !this.hasBlockingWorkItems()) {
            this.removeEventListeners();
            this.leave();
        }
    }

    public void workItemCompleted(org.drools.runtime.process.WorkItem workItem) {
        if (this.workItems.remove(workItem)) {
            String taskName = (String)workItem.getParameter("name");
            Set<Task> tasks = this.getTaskNode().getTasks();
            for (Task task : tasks) {
                Event event;
                String actorId;
                String swimlaneName;
                SwimlaneContextInstance swimlaneContextInstance;
                if (!taskName.equals(task.getName())) continue;
                TaskUtils.restoreVariables((WorkItemImpl)workItem, task, this);
                if (task.getSwimlane() != null && (swimlaneContextInstance = (SwimlaneContextInstance)this.resolveContextInstance("SwimlaneScope", swimlaneName = task.getSwimlane().getName())).getActorId(swimlaneName) == null && (actorId = (String)workItem.getResult("ActorId")) != null) {
                    swimlaneContextInstance.setActorId(swimlaneName, (String)workItem.getResult("ActorId"));
                }
                if ((event = task.getEvent("task-end")) == null) break;
                JpdlNodeInstance.JpdlExecutionContext context = new JpdlNodeInstance.JpdlExecutionContext(this);
                context.setTask(task);
                this.executeActions(event.getActions(), context);
                break;
            }
            if (!this.hasBlockingWorkItems()) {
                this.removeEventListeners();
                String result = (String)workItem.getResult("Result");
                if (result != null) {
                    this.leave(result);
                } else {
                    this.leave();
                }
            }
        }
    }

    public org.drools.runtime.process.WorkItem findWorkItem(Task task) {
        for (WorkItemImpl workItem : this.workItems) {
            if (!task.getName().equals(workItem.getName())) continue;
            return workItem;
        }
        return null;
    }

    public void leave(String type) {
        if (this.hasBlockingWorkItems()) {
            throw new IllegalStateException("task-node '" + this.getNode().getName() + "' still has blocking tasks");
        }
        if (this.getTaskNode().isEndTasks()) {
            for (WorkItemImpl workItem : this.workItems) {
                this.getProcessInstance().getWorkingMemory().getWorkItemManager().internalAbortWorkItem(workItem.getId());
            }
        }
        super.leave(type);
    }
}

