/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.instance.node;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.drools.jpdl.instance.node.JpdlNodeInstance;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.context.swimlane.SwimlaneContextInstance;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.instance.impl.WorkItemImpl;
import org.jbpm.JbpmException;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskController;

public final class TaskUtils {
    private TaskUtils() {
    }

    public static WorkItem createWorkItem(Task task, JpdlNodeInstance nodeInstance) {
        Event event;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setName("JpdlTask");
        workItem.setProcessInstanceId(nodeInstance.getProcessInstance().getId());
        workItem.setParameter("name", (Object)task.getName());
        String description = task.getDescription();
        workItem.setParameter("signalling", (Object)task.isSignalling());
        workItem.setParameter("blocking", (Object)task.isBlocking());
        if (description != null && description.indexOf("#{") != -1) {
            Object result = JbpmExpressionEvaluator.evaluate((String)description, (ExecutionContext)nodeInstance.new JpdlNodeInstance.JpdlExecutionContext());
            if (result != null) {
                description = result.toString();
            }
        }
        workItem.setParameter("Description", (Object)description);
        TaskUtils.initializeVariables(workItem, task, nodeInstance);
        if (task.getDueDate() != null) {
            BusinessCalendar businessCalendar = new BusinessCalendar();
            workItem.setParameter("dueDate", (Object)businessCalendar.add(new Date(), new Duration(task.getDueDate())));
        }
        if (task.getSwimlane() != null) {
            String swimlaneName = task.getSwimlane().getName();
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)nodeInstance.resolveContextInstance("SwimlaneScope", swimlaneName);
            String actorId = swimlaneContextInstance.getActorId(swimlaneName);
            if (actorId == null) {
                actorId = TaskUtils.assignTask(task, nodeInstance);
            }
            workItem.setParameter("ActorId", (Object)actorId);
        }
        if ((event = task.getEvent("task-create")) != null) {
            JpdlNodeInstance.JpdlExecutionContext context = nodeInstance.new JpdlNodeInstance.JpdlExecutionContext();
            context.setTask(task);
            nodeInstance.executeActions(event.getActions(), context);
        }
        return workItem;
    }

    private static void initializeVariables(WorkItemImpl workItem, Task task, JpdlNodeInstance nodeInstance) {
        List variableAccesses;
        Delegation taskControllerDelegation;
        TaskController taskController = task.getTaskController();
        if (taskController != null && (taskControllerDelegation = taskController.getTaskControllerDelegation()) == null && (variableAccesses = taskController.getVariableAccesses()) != null) {
            for (VariableAccess variableAccess : variableAccesses) {
                String mappedName = variableAccess.getMappedName();
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)nodeInstance.resolveContextInstance("VariableScope", variableName);
                Object value = variableScopeInstance.getVariable(variableName);
                workItem.setParameter(mappedName, value);
            }
        }
    }

    private static String assignTask(Task task, JpdlNodeInstance nodeInstance) {
        Event event = task.getEvent("task-assign");
        if (event != null) {
            JpdlNodeInstance.JpdlExecutionContext context = nodeInstance.new JpdlNodeInstance.JpdlExecutionContext();
            context.setTask(task);
            nodeInstance.executeActions(event.getActions(), context);
        }
        if (task.getActorIdExpression() != null) {
            return TaskUtils.resolveActor(task.getActorIdExpression(), nodeInstance);
        }
        if (task.getSwimlane().getActorIdExpression() != null) {
            return TaskUtils.resolveActor(task.getSwimlane().getActorIdExpression(), nodeInstance);
        }
        return null;
    }

    private static String resolveActor(String expression, JpdlNodeInstance nodeInstance) {
        Object result = JbpmExpressionEvaluator.evaluate((String)expression, (ExecutionContext)nodeInstance.new JpdlNodeInstance.JpdlExecutionContext());
        if (result == null) {
            throw new JbpmException("actor-id expression '" + expression + "' returned null");
        }
        if (result instanceof String) {
            return (String)result;
        }
        throw new JbpmException("actor-id expression '" + expression + "' didn't resolve to a java.lang.String: '" + result + "' (" + result.getClass().getName() + ")");
    }

    public static void restoreVariables(WorkItemImpl workItem, Task task, JpdlNodeInstance nodeInstance) {
        block6: {
            block5: {
                String mappedName;
                List variableAccesses;
                TaskController taskController = task.getTaskController();
                if (taskController == null) break block5;
                Delegation taskControllerDelegation = taskController.getTaskControllerDelegation();
                if (taskControllerDelegation != null || (variableAccesses = taskController.getVariableAccesses()) == null) break block6;
                String missingTaskVariables = null;
                for (VariableAccess variableAccess : variableAccesses) {
                    mappedName = variableAccess.getMappedName();
                    Object value = workItem.getParameter(mappedName);
                    if (!variableAccess.isRequired() || value == null) continue;
                    if (missingTaskVariables == null) {
                        missingTaskVariables = mappedName;
                        continue;
                    }
                    missingTaskVariables = missingTaskVariables + ", " + mappedName;
                }
                if (missingTaskVariables != null) {
                    throw new IllegalArgumentException("missing task variables: " + missingTaskVariables);
                }
                for (VariableAccess variableAccess : variableAccesses) {
                    Object value;
                    mappedName = variableAccess.getMappedName();
                    String variableName = variableAccess.getVariableName();
                    if (!variableAccess.isWritable() || (value = workItem.getParameter(mappedName)) == null) continue;
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)nodeInstance.resolveContextInstance("VariableScope", variableName);
                    variableScopeInstance.setVariable(variableName, value);
                }
                break block6;
            }
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)nodeInstance.getProcessInstance().getContextInstance("VariableScope");
            for (Map.Entry entry : workItem.getResults().entrySet()) {
                variableScopeInstance.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

