/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetProvider;
import org.drools.compiler.PackageBuilder;
import org.drools.jsr94.rules.RuleEngineTestBase;
import org.drools.rule.Package;

public class RuleExecutionSetProviderTest
extends RuleEngineTestBase {
    private RuleAdministrator ruleAdministrator;
    private RuleExecutionSetProvider ruleSetProvider;
    private Package pkg;

    protected void setUp() throws Exception {
        super.setUp();
        this.ruleAdministrator = this.ruleServiceProvider.getRuleAdministrator();
        this.ruleSetProvider = this.ruleAdministrator.getRuleExecutionSetProvider(null);
        this.initPackage();
    }

    private void initPackage() {
        InputStream resourceAsStream = null;
        try {
            Package pkg;
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(RuleEngineTestBase.class.getResourceAsStream(this.bindUri)));
            this.pkg = pkg = builder.getPackage();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError("setUp() could not init the RuleSet due to an IOException in the InputStream: " + e);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("setUp() could not init the RuleSet, " + e);
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void tearDown() {
        this.pkg = null;
    }

    public void testCreateFromSerializable() throws Exception {
        RuleExecutionSet ruleExecutionSet = this.ruleSetProvider.createRuleExecutionSet((Serializable)this.pkg, null);
        RuleExecutionSetProviderTest.assertEquals((String)"rule set name", (String)"SistersRules", (String)ruleExecutionSet.getName());
        RuleExecutionSetProviderTest.assertEquals((String)"number of rules", (int)1, (int)ruleExecutionSet.getRules().size());
    }

    public void testCreateFromURI() throws Exception {
        String rulesUri = RuleEngineTestBase.class.getResource(this.bindUri).toExternalForm();
        RuleExecutionSet testRuleSet = this.ruleSetProvider.createRuleExecutionSet(rulesUri, null);
        RuleExecutionSetProviderTest.assertEquals((String)"rule set name", (String)"SistersRules", (String)testRuleSet.getName());
        RuleExecutionSetProviderTest.assertEquals((String)"number of rules", (int)1, (int)testRuleSet.getRules().size());
    }

    public void testIncompatibleSerializableCreation() throws Exception {
        try {
            RuleExecutionSet testRuleSet = this.ruleSetProvider.createRuleExecutionSet(new ArrayList(), null);
            RuleExecutionSetProviderTest.fail((String)("Should have thrown an IllegalArgumentException. ArrayList objects are not valid AST representations. " + testRuleSet));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

