/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.rules.ConfigurationException;
import javax.rules.ObjectFilter;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import junit.framework.TestCase;
import org.drools.jsr94.rules.ExampleRuleEngineFacade;
import org.drools.jsr94.rules.Person;
import org.drools.jsr94.rules.RuleServiceProviderImpl;

public class StatelessRuleSessionTest
extends TestCase {
    private ExampleRuleEngineFacade sessionBuilder;
    private final String bindUri = "sisters.drl";
    private final String bindUri_drl = "sisters_expander.drl";
    private final String bindUri_dsl = "sisters_expander.dsl";
    private final String bindUri_xml = "sisters.xml";
    private final String bindUri_globals = "sisters_globals.drl";

    protected void setUp() throws Exception {
        super.setUp();
        this.sessionBuilder = new ExampleRuleEngineFacade();
        this.sessionBuilder.addRuleExecutionSet(this.bindUri, StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri));
        HashMap<String, String> map = new HashMap<String, String>();
        InputStreamReader reader = new InputStreamReader(StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_dsl));
        map.put("dsl", this.getDSLText(reader).toString());
        this.sessionBuilder.addRuleExecutionSet(this.bindUri_drl, StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_drl), map);
        HashMap<String, String> map_xml = new HashMap<String, String>();
        map_xml.put("source", "xml");
        this.sessionBuilder.addRuleExecutionSet(this.bindUri_xml, StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_xml), map_xml);
        this.sessionBuilder.addRuleExecutionSet(this.bindUri_globals, StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_globals));
    }

    private StringBuffer getDSLText(Reader reader) throws IOException {
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text;
    }

    public void testCreateRuleExecutionSetFromStreamWithXml() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("source", "xml");
            RuleServiceProviderManager.registerRuleServiceProvider((String)"http://drools.org/", RuleServiceProviderImpl.class);
            RuleServiceProvider ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)"http://drools.org/");
            LocalRuleExecutionSetProvider ruleSetProvider = ruleServiceProvider.getRuleAdministrator().getLocalRuleExecutionSetProvider(null);
            RuleExecutionSet ruleExecutionSet = ruleSetProvider.createRuleExecutionSet(StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_xml), map);
            StatelessRuleSessionTest.assertNotNull((Object)ruleExecutionSet);
        }
        catch (RemoteException e) {
            StatelessRuleSessionTest.fail();
        }
        catch (ConfigurationException e) {
            StatelessRuleSessionTest.fail();
        }
        catch (RuleExecutionSetCreateException e) {
            StatelessRuleSessionTest.fail();
        }
        catch (IOException e) {
            StatelessRuleSessionTest.fail();
        }
    }

    public void testCreateRuleExecutionSetFromStreamReaderWithXml() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("source", "xml");
            RuleServiceProviderManager.registerRuleServiceProvider((String)"http://drools.org/", RuleServiceProviderImpl.class);
            RuleServiceProvider ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)"http://drools.org/");
            LocalRuleExecutionSetProvider ruleSetProvider = ruleServiceProvider.getRuleAdministrator().getLocalRuleExecutionSetProvider(null);
            InputStreamReader ruleReader = new InputStreamReader(StatelessRuleSessionTest.class.getResourceAsStream(this.bindUri_xml));
            RuleExecutionSet ruleExecutionSet = ruleSetProvider.createRuleExecutionSet((Reader)ruleReader, map);
            StatelessRuleSessionTest.assertNotNull((Object)ruleExecutionSet);
        }
        catch (RemoteException e) {
            StatelessRuleSessionTest.fail();
        }
        catch (ConfigurationException e) {
            StatelessRuleSessionTest.fail();
        }
        catch (RuleExecutionSetCreateException e) {
            StatelessRuleSessionTest.fail();
        }
        catch (IOException e) {
            StatelessRuleSessionTest.fail();
        }
    }

    public void testExecuteRulesGlobals() throws Exception {
        HashMap<String, Vector> map = new HashMap<String, Vector>();
        Vector v = new Vector();
        map.put("vector", v);
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri_globals, map);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        List outList = statelessSession.executeRules(inObjects);
        StatelessRuleSessionTest.assertEquals((String)"incorrect size", (int)5, (int)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        v = (Vector)map.get("vector");
        StatelessRuleSessionTest.assertNotNull((String)"Global Vector null", (Object)v);
        this.assertContains(v, "rebecca and jeannie are sisters");
        this.assertContains(v, "jeannie and rebecca are sisters");
        StatelessRuleSessionTest.assertEquals((String)"Vector v incorrect size", (int)2, (int)v.size());
        statelessSession.release();
    }

    public void testExecuteRules() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        List outList = statelessSession.executeRules(inObjects);
        StatelessRuleSessionTest.assertEquals((String)"incorrect size", (int)5, (int)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        statelessSession.release();
    }

    public void testExecuteRulesWithXml() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri_xml);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        List outList = statelessSession.executeRules(inObjects);
        StatelessRuleSessionTest.assertEquals((String)"incorrect size", (int)5, (int)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        statelessSession.release();
    }

    public void xxxtestExecuteRules_dsl() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri_drl);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        List outList = statelessSession.executeRules(inObjects);
        StatelessRuleSessionTest.assertEquals((String)"incorrect size", (int)5, (int)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        statelessSession.release();
    }

    public void testExecuteRulesWithFilter() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        List outList = statelessSession.executeRules(inObjects, (ObjectFilter)new PersonFilter());
        StatelessRuleSessionTest.assertEquals((String)"incorrect size", (int)3, (int)outList.size());
        StatelessRuleSessionTest.assertTrue((String)"where is bob", (boolean)outList.contains(bob));
        StatelessRuleSessionTest.assertTrue((String)"where is rebecca", (boolean)outList.contains(rebecca));
        StatelessRuleSessionTest.assertTrue((String)"where is jeannie", (boolean)outList.contains(jeannie));
    }

    public void testExecuteRulesWithFilter_dsl() throws Exception {
        StatelessRuleSession statelessSession = this.sessionBuilder.getStatelessRuleSession(this.bindUri_drl);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        List outList = statelessSession.executeRules(inObjects, (ObjectFilter)new PersonFilter());
        StatelessRuleSessionTest.assertEquals((String)"incorrect size", (int)3, (int)outList.size());
        StatelessRuleSessionTest.assertTrue((String)"where is bob", (boolean)outList.contains(bob));
        StatelessRuleSessionTest.assertTrue((String)"where is rebecca", (boolean)outList.contains(rebecca));
        StatelessRuleSessionTest.assertTrue((String)"where is jeannie", (boolean)outList.contains(jeannie));
    }

    protected void assertContains(List expected, Object object) {
        if (expected.contains(object)) {
            return;
        }
        StatelessRuleSessionTest.fail((String)(object + " not in " + expected));
    }

    static class PersonFilter
    implements ObjectFilter {
        PersonFilter() {
        }

        public Object filter(Object object) {
            return object instanceof Person ? object : null;
        }

        public void reset() {
        }
    }
}

