/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.rules.Handle;
import javax.rules.ObjectFilter;
import org.drools.jsr94.rules.Person;
import org.drools.jsr94.rules.RuleEngineTestBase;

public class StatefulRuleSessionTest
extends RuleEngineTestBase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testContainsObject() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri);
        Person bob = new Person("bob");
        Handle handle = this.statefulSession.addObject((Object)bob);
        StatefulRuleSessionTest.assertTrue((String)"where is bob", (boolean)this.statefulSession.containsObject(handle));
    }

    public void testAddObject() throws Exception {
    }

    public void testJsr94FactHandleFactoryAvailable() throws ClassNotFoundException {
        ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.drools.jsr94.rules.Jsr94FactHandleFactory");
    }

    public void testAddObjects() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri);
        ArrayList<Person> inObjects = new ArrayList<Person>();
        Person bob = new Person("bob");
        inObjects.add(bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        inObjects.add(rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        inObjects.add(jeannie);
        List handleList = this.statefulSession.addObjects(inObjects);
        StatefulRuleSessionTest.assertEquals((String)"incorrect size", (int)3, (int)handleList.size());
        StatefulRuleSessionTest.assertEquals((String)"where is bob", (Object)bob, (Object)this.statefulSession.getObject((Handle)handleList.get(0)));
        StatefulRuleSessionTest.assertEquals((String)"where is rebecca", (Object)rebecca, (Object)this.statefulSession.getObject((Handle)handleList.get(1)));
        StatefulRuleSessionTest.assertEquals((String)"where is jeannie", (Object)jeannie, (Object)this.statefulSession.getObject((Handle)handleList.get(2)));
    }

    public void testGetObject() throws Exception {
    }

    public void testUpdateObject() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri);
        Person bob = new Person("bob");
        Handle handle = this.statefulSession.addObject((Object)bob);
        bob = new Person("boby");
        this.statefulSession.updateObject(handle, (Object)bob);
        StatefulRuleSessionTest.assertEquals((String)"where is boby", (Object)bob, (Object)this.statefulSession.getObject(handle));
    }

    public void testRemoveObject() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri);
        Person bob = new Person("bob");
        Handle handle = this.statefulSession.addObject((Object)bob);
        StatefulRuleSessionTest.assertTrue((String)"where is bob", (boolean)this.statefulSession.containsObject(handle));
        this.statefulSession.removeObject(handle);
        StatefulRuleSessionTest.assertTrue((String)"bob still there", (!this.statefulSession.containsObject(handle) ? 1 : 0) != 0);
    }

    public void testGetObjects() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri);
        Person bob = new Person("bob");
        this.statefulSession.addObject((Object)bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        this.statefulSession.addObject((Object)rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        this.statefulSession.addObject((Object)jeannie);
        this.statefulSession.executeRules();
        List outList = this.statefulSession.getObjects();
        StatefulRuleSessionTest.assertEquals((String)"incorrect size", (int)5, (int)outList.size());
        StatefulRuleSessionTest.assertTrue((String)"where is bob", (boolean)outList.contains(bob));
        StatefulRuleSessionTest.assertTrue((String)"where is rebecca", (boolean)outList.contains(rebecca));
        StatefulRuleSessionTest.assertTrue((String)"where is jeannie", (boolean)outList.contains(jeannie));
        StatefulRuleSessionTest.assertTrue((boolean)outList.contains("rebecca and jeannie are sisters"));
        StatefulRuleSessionTest.assertTrue((boolean)outList.contains("jeannie and rebecca are sisters"));
        this.statefulSession.release();
    }

    public void testGetObjectsWithFilter() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri);
        Person bob = new Person("bob");
        this.statefulSession.addObject((Object)bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        this.statefulSession.addObject((Object)rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        this.statefulSession.addObject((Object)jeannie);
        this.statefulSession.executeRules();
        List outList = this.statefulSession.getObjects((ObjectFilter)new PersonFilter());
        StatefulRuleSessionTest.assertEquals((String)"incorrect size", (int)3, (int)outList.size());
        StatefulRuleSessionTest.assertTrue((String)"where is bob", (boolean)outList.contains(bob));
        StatefulRuleSessionTest.assertTrue((String)"where is rebecca", (boolean)outList.contains(rebecca));
        StatefulRuleSessionTest.assertTrue((String)"where is jeannie", (boolean)outList.contains(jeannie));
        this.statefulSession.release();
    }

    public void testExecuteRules() throws Exception {
    }

    public void testReset() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri);
        Person bob = new Person("bob");
        Handle handle = this.statefulSession.addObject((Object)bob);
        StatefulRuleSessionTest.assertTrue((String)"where is bob", (boolean)this.statefulSession.containsObject(handle));
        this.statefulSession.reset();
        StatefulRuleSessionTest.assertTrue((String)"bob still there", (!this.statefulSession.containsObject(handle) ? 1 : 0) != 0);
    }

    public void testExecuteRulesGlobals() throws Exception {
        HashMap<String, Vector> map = new HashMap<String, Vector>();
        Vector v = new Vector();
        map.put("vector", v);
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri_globals, map);
        Person bob = new Person("bob");
        this.statefulSession.addObject((Object)bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        this.statefulSession.addObject((Object)rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        this.statefulSession.addObject((Object)jeannie);
        this.statefulSession.executeRules();
        List outList = this.statefulSession.getObjects();
        StatefulRuleSessionTest.assertEquals((String)"incorrect size", (int)5, (int)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        v = (Vector)map.get("vector");
        StatefulRuleSessionTest.assertNotNull((String)"Global Vector null", (Object)v);
        this.assertContains(v, "rebecca and jeannie are sisters");
        this.assertContains(v, "jeannie and rebecca are sisters");
        StatefulRuleSessionTest.assertEquals((String)"Vector v incorrect size", (int)2, (int)v.size());
        this.statefulSession.release();
    }

    public void xxxtestExecuteRules_dsl() throws Exception {
        this.statefulSession = this.engine.getStatefulRuleSession(this.bindUri_drl);
        Person bob = new Person("bob");
        this.statefulSession.addObject((Object)bob);
        Person rebecca = new Person("rebecca");
        rebecca.addSister("jeannie");
        this.statefulSession.addObject((Object)rebecca);
        Person jeannie = new Person("jeannie");
        jeannie.addSister("rebecca");
        this.statefulSession.addObject((Object)jeannie);
        this.statefulSession.executeRules();
        List outList = this.statefulSession.getObjects();
        StatefulRuleSessionTest.assertEquals((String)"incorrect size", (int)5, (int)outList.size());
        this.assertContains(outList, bob);
        this.assertContains(outList, rebecca);
        this.assertContains(outList, jeannie);
        this.assertContains(outList, "rebecca and jeannie are sisters");
        this.assertContains(outList, "jeannie and rebecca are sisters");
        this.statefulSession.release();
    }

    protected void assertContains(List expected, Object object) {
        if (expected.contains(object)) {
            return;
        }
        StatefulRuleSessionTest.fail((String)(object + " not in " + expected));
    }

    static class PersonFilter
    implements ObjectFilter {
        PersonFilter() {
        }

        public Object filter(Object object) {
            return object instanceof Person ? object : null;
        }

        public void reset() {
        }
    }
}

